/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.HmacSignatureGenerator;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.SignatureGenerator;
import java.util.LinkedHashMap;

public class Margin {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String CROSS_MARGIN_TRANSFER = "/sapi/v1/margin/transfer";
    private final String BORROW = "/sapi/v1/margin/loan";
    private final String REPAY = "/sapi/v1/margin/repay";
    private final String ASSET = "/sapi/v1/margin/asset";
    private final String PAIR = "/sapi/v1/margin/pair";
    private final String ALL_ASSETS = "/sapi/v1/margin/allAssets";
    private final String ALL_PAIRS = "/sapi/v1/margin/allPairs";
    private final String PRICE_INDEX = "/sapi/v1/margin/priceIndex";
    private final String ORDER = "/sapi/v1/margin/order";
    private final String OPEN_ORDERS = "/sapi/v1/margin/openOrders";
    private final String TRANSFER_HISTORY = "/sapi/v1/margin/transfer";
    private final String LOAN_RECORD = "/sapi/v1/margin/loan";
    private final String REPAY_RECORD = "/sapi/v1/margin/repay";
    private final String INTEREST_HISTORY = "/sapi/v1/margin/interestHistory";
    private final String FORCE_LIQUIDATION_RECORD = "/sapi/v1/margin/forceLiquidationRec";
    private final String ACCOUNT = "/sapi/v1/margin/account";
    private final String ALL_ORDERS = "/sapi/v1/margin/allOrders";
    private final String OCO_ORDER = "/sapi/v1/margin/order/oco";
    private final String ORDER_LIST = "/sapi/v1/margin/orderList";
    private final String GET_ALL_OCO = "/sapi/v1/margin/allOrderList";
    private final String GET_OPEN_OCO = "/sapi/v1/margin/openOrderList";
    private final String MY_TRADES = "/sapi/v1/margin/myTrades";
    private final String MAX_BORROW = "/sapi/v1/margin/maxBorrowable";
    private final String MAX_TRANSFERABLE = "/sapi/v1/margin/maxTransferable";
    private final String ISOLATED_TRANSFER = "/sapi/v1/margin/isolated/transfer";
    private final String ISOLATED_ACCOUNT = "/sapi/v1/margin/isolated/account";
    private final String ISOLATED_ACCOUNT_LIMIT = "/sapi/v1/margin/isolated/accountLimit";
    private final String ISOLATED_SYMBOL = "/sapi/v1/margin/isolated/pair";
    private final String ALL_ISOLATED_SYMBOL = "/sapi/v1/margin/isolated/allPairs";
    private final String BNB_BURN = "/sapi/v1/bnbBurn";
    private final String INTEREST_RATE_HIST = "/sapi/v1/margin/interestRateHistory";
    private final String CROSS_MARGIN_DATA = "/sapi/v1/margin/crossMarginData";
    private final String ISOLATED_MARGIN_DATA = "/sapi/v1/margin/isolatedMarginData";
    private final String ISOLATED_MARGIN_TIER = "/sapi/v1/margin/isolatedMarginTier";
    private final String ORDER_RATE_LIMIT = "/sapi/v1/margin/rateLimit/order";
    private final String DRIBBLET = "/sapi/v1/margin/dribblet";

    public Margin(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public Margin(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String crossMarginTransfer(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        ParameterChecker.checkParameter(parameters, "type", Integer.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/transfer", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String borrow(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/loan", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String repay(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/repay", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String asset(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        return this.requestHandler.sendWithApiKeyRequest(this.baseUrl, "/sapi/v1/margin/asset", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String pair(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendWithApiKeyRequest(this.baseUrl, "/sapi/v1/margin/pair", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String allAssets() {
        return this.requestHandler.sendWithApiKeyRequest(this.baseUrl, "/sapi/v1/margin/allAssets", null, HttpMethod.GET, this.showLimitUsage);
    }

    public String allPairs() {
        return this.requestHandler.sendWithApiKeyRequest(this.baseUrl, "/sapi/v1/margin/allPairs", null, HttpMethod.GET, this.showLimitUsage);
    }

    public String priceIndex(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendWithApiKeyRequest(this.baseUrl, "/sapi/v1/margin/priceIndex", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String newOrder(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/order", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String cancelOrder(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/order", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String cancelOpenOrders(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/openOrders", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String transferHistory(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/transfer", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String loanRecord(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/loan", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String repayRecord(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/repay", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String interestHistory(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/interestHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String forceLiquidationRec(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/forceLiquidationRec", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String account(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/account", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getOrder(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/order", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getOpenOrders(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/openOrders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getAllOrders(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/allOrders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String ocoOrder(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "quantity");
        ParameterChecker.checkRequiredParameter(parameters, "price");
        ParameterChecker.checkRequiredParameter(parameters, "stopPrice");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/order/oco", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String cancelOcoOrder(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/orderList", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String getOcoOrder(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/orderList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getAllOcoOrders(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/allOrderList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getOcoOpenOrders(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/openOrderList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String trades(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/myTrades", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String maxBorrow(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/maxBorrowable", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String maxTransferable(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/maxTransferable", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String isolatedTransfer(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "transFrom", String.class);
        ParameterChecker.checkParameter(parameters, "transTo", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/transfer", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String getIsolatedTransfer(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/transfer", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String isolatedAccount(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/account", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String disableIsolatedAccount(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/account", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String enableIsolatedAccount(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/account", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String getIsolatedAccountLimit(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/accountLimit", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getIsolatedSymbol(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/pair", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getAllIsolatedSymbols(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/allPairs", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String bnbBurn(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bnbBurn", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String getBnbBurn(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bnbBurn", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String interestRateHistory(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/interestRateHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String crossMarginData(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/crossMarginData", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String isolatedMarginData(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolatedMarginData", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String isolatedMarginTier(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolatedMarginTier", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String orderRateLimit(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/rateLimit/order", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String dribblet(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/dribblet", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

