/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.HmacSignatureGenerator;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.SignatureGenerator;
import java.util.LinkedHashMap;

public class Savings {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String FLEXIBLE_PRODUCT = "/sapi/v1/lending/daily/product/list";
    private final String PURCHASE_QUOTA = "/sapi/v1/lending/daily/userLeftQuota";
    private final String PURCHASE_PRODUCT = "/sapi/v1/lending/daily/purchase";
    private final String DAILY_REDEMPTION_QUOTA = "/sapi/v1/lending/daily/userRedemptionQuota";
    private final String REDEEM_PRODUCT = "/sapi/v1/lending/daily/redeem";
    private final String PRODUCT_POSTION = "/sapi/v1/lending/daily/token/position";
    private final String ACTIVITY_PROJECT = "/sapi/v1/lending/project/list";
    private final String PURCHASE_ACTIVITY = "/sapi/v1/lending/customizedFixed/purchase";
    private final String PROJECT_POSITION = "/sapi/v1/lending/project/position/list";
    private final String LENDING_ACCOUNT = "/sapi/v1/lending/union/account";
    private final String PURCHASE_RECORD = "/sapi/v1/lending/union/purchaseRecord";
    private final String REDEMPTION_RECORD = "/sapi/v1/lending/union/redemptionRecord";
    private final String INTEREST_HISTORY = "/sapi/v1/lending/union/interestHistory";
    private final String CHANGE_TO_DAILY_POSITION = "/sapi/v1/lending/positionChanged";

    public Savings(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public Savings(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String flexibleProducts(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/daily/product/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String purchaseQuotaFlexible(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/daily/userLeftQuota", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String purchaseFlexibleProduct(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/daily/purchase", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String dailyRedemptionQuota(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/daily/userRedemptionQuota", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String redeemFlexibleProduct(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/daily/redeem", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String flexibleProductPosition(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/daily/token/position", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String projectList(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/project/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String purchaseProject(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "projectId", String.class);
        ParameterChecker.checkParameter(parameters, "lot", Long.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/customizedFixed/purchase", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String projectPosition(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/project/position/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String lendingAccount(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/union/account", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String purchaseRecord(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "lendingType", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/union/purchaseRecord", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String redemptionRecord(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "lendingType", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/union/redemptionRecord", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String interestHistory(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "lendingType", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/union/interestHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String changeToDailyPosition(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "projectId", String.class);
        ParameterChecker.checkParameter(parameters, "lot", Long.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/positionChanged", parameters, HttpMethod.POST, this.showLimitUsage);
    }
}

