/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.HmacSignatureGenerator;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.SignatureGenerator;
import java.util.LinkedHashMap;

public class Staking {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String PRODUCT_LIST = "/sapi/v1/staking/productList";
    private final String PURCHASE = "/sapi/v1/staking/purchase";
    private final String REDEEM = "/sapi/v1/staking/redeem";
    private final String POSITION = "/sapi/v1/staking/position";
    private final String STAKING_RECORD = "/sapi/v1/staking/stakingRecord";
    private final String AUTO_STAKING = "/sapi/v1/staking/setAutoStaking";
    private final String LEFT_QUOTA = "/sapi/v1/staking/personalLeftQuota";

    public Staking(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public Staking(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String productList(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "product", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/staking/productList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String purchase(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "product", String.class);
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        ParameterChecker.checkParameter(parameters, "amount", Double.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/staking/purchase", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String redeem(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "product", String.class);
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/staking/redeem", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String getPosition(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "product", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/staking/position", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String stakingRecord(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "product", String.class);
        ParameterChecker.checkParameter(parameters, "txnType", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/staking/stakingRecord", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String setAutoStaking(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "product", String.class);
        ParameterChecker.checkParameter(parameters, "positionId", String.class);
        ParameterChecker.checkParameter(parameters, "renewable", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/staking/setAutoStaking", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String personalLeftQuota(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "product", String.class);
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/staking/personalLeftQuota", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

