/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.HmacSignatureGenerator;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.SignatureGenerator;
import java.util.LinkedHashMap;

public class SubAccount {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String CREATE_SUB = "/sapi/v1/sub-account/virtualSubAccount";
    private final String QUERY_SUB_LIST = "/sapi/v1/sub-account/list";
    private final String QUERY_SPOT_TRANSFER_HIST = "/sapi/v1/sub-account/sub/transfer/history";
    private final String FUTURES_TRANSFER = "/sapi/v1/sub-account/futures/internalTransfer";
    private final String SUB_ACC_ASSETS = "/sapi/v3/sub-account/assets";
    private final String SPOT_ASSET_SUMMARY = "/sapi/v1/sub-account/spotSummary";
    private final String SUB_DEPOSIT_ADDRESS = "/sapi/v1/capital/deposit/subAddress";
    private final String SUB_DEPOSIT_HISTORY = "/sapi/v1/capital/deposit/subHisrec";
    private final String SUB_ACC_STATUS = "/sapi/v1/sub-account/status";
    private final String ENABLE_MARGIN = "/sapi/v1/sub-account/margin/enable";
    private final String SUB_ACC_MARGIN = "/sapi/v1/sub-account/margin/account";
    private final String SUB_ACC_MARGIN_SUMMARY = "/sapi/v1/sub-account/margin/accountSummary";
    private final String ENABLE_FUTURES = "/sapi/v1/sub-account/futures/enable";
    private final String SUB_ACC_FUTURES = "/sapi/v1/sub-account/futures/account";
    private final String SUB_ACC_FUTURES_SUMMARY = "/sapi/v1/sub-account/futures/accountSummary";
    private final String SUB_ACC_POSITION_RISK = "/sapi/v1/sub-account/futures/positionRisk";
    private final String SUB_ACC_FUTURES_TRANSFER = "/sapi/v1/sub-account/futures/transfer";
    private final String SUB_ACC_MARGIN_TRANSFER = "/sapi/v1/sub-account/margin/transfer";
    private final String SUB_TO_SUB = "/sapi/v1/sub-account/transfer/subToSub";
    private final String SUB_TO_MASTER = "/sapi/v1/sub-account/transfer/subToMaster";
    private final String SUB_TRANSFER_HIST = "/sapi/v1/sub-account/transfer/subUserHistory";
    private final String SUB_UNIVERSAL_TRANSFER = "/sapi/v1/sub-account/universalTransfer";
    private final String SUB_FUTURES_ACCOUNT_V2 = "/sapi/v2/sub-account/futures/account";
    private final String SUB_FUTURES_ACCOUNT_SUMMARY_V2 = "/sapi/v2/sub-account/futures/accountSummary";
    private final String SUB_FUTURES_POSITION_RISK_V2 = "/sapi/v2/sub-account/futures/positionRisk";
    private final String ENABLE_LEVERAGE = "/sapi/v1/sub-account/blvt/enable";
    private final String IP_RESTRICTION = "/sapi/v1/sub-account/subAccountApi/ipRestriction";
    private final String IP_LIST = "/sapi/v1/sub-account/subAccountApi/ipRestriction/ipList";
    private final String MANAGED_SUB_DEPOSIT = "/sapi/v1/managed-subaccount/deposit";
    private final String MANAGED_SUB_DETAILS = "/sapi/v1/managed-subaccount/asset";
    private final String MANAGED_SUB_WITHDRAW = "/sapi/v1/managed-subaccount/withdraw";
    private final String MANAGED_SUB_SNAPSHOT = "/sapi/v1/managed-subaccount/accountSnapshot";

    public SubAccount(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public SubAccount(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String createVirtualSubAccount(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "subAccountString", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/virtualSubAccount", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String subAccountList(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String spotTransferHistory(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/sub/transfer/history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getFuturesInternalTransfer(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        ParameterChecker.checkParameter(parameters, "futuresType", Integer.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/futures/internalTransfer", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String futuresInternalTransfer(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "fromEmail", String.class);
        ParameterChecker.checkParameter(parameters, "toEmail", String.class);
        ParameterChecker.checkParameter(parameters, "futuresType", Integer.class);
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/futures/internalTransfer", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String assets(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v3/sub-account/assets", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String spotAccountSummary(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/spotSummary", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String depositAddress(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        ParameterChecker.checkParameter(parameters, "coin", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/capital/deposit/subAddress", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String depositHistory(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/capital/deposit/subHisrec", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String accountStatus(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/status", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String enableMargin(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/margin/enable", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String marginAccount(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/margin/account", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String marginAccountSummary(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/margin/accountSummary", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String enableFutures(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/futures/enable", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String futuresAccount(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/futures/account", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String futuresAccountSummary(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/futures/accountSummary", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String futuresPositionRisk(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/futures/positionRisk", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String futuresTransfer(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        ParameterChecker.checkParameter(parameters, "type", Integer.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/futures/transfer", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String marginTransfer(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        ParameterChecker.checkParameter(parameters, "type", Integer.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/margin/transfer", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String subAccountToSubAccount(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "toEmail", String.class);
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/transfer/subToSub", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String subAccountToMaster(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/transfer/subToMaster", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String transferHistory(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/transfer/subUserHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String universalTransfer(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "fromAccountType", String.class);
        ParameterChecker.checkParameter(parameters, "toAccountType", String.class);
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/universalTransfer", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String queryUniversalTransfer(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/universalTransfer", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String futuresAccountV2(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        ParameterChecker.checkParameter(parameters, "futuresType", Integer.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v2/sub-account/futures/account", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String futuresAccountSummaryV2(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "futuresType", Integer.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v2/sub-account/futures/accountSummary", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String futuresPositionRiskV2(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        ParameterChecker.checkParameter(parameters, "futuresType", Integer.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v2/sub-account/futures/positionRisk", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String enableLeverageToken(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        ParameterChecker.checkParameter(parameters, "enableBlvt", Boolean.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/blvt/enable", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String enableIpRestriction(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        ParameterChecker.checkParameter(parameters, "subAccountApiKey", String.class);
        ParameterChecker.checkParameter(parameters, "ipRestrict", Boolean.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/subAccountApi/ipRestriction", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String getIpRestriction(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        ParameterChecker.checkParameter(parameters, "subAccountApiKey", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/subAccountApi/ipRestriction", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String addIpList(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        ParameterChecker.checkParameter(parameters, "subAccountApiKey", String.class);
        ParameterChecker.checkParameter(parameters, "ipAddress", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/subAccountApi/ipRestriction/ipList", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String deleteIpList(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        ParameterChecker.checkParameter(parameters, "subAccountApiKey", String.class);
        ParameterChecker.checkParameter(parameters, "ipAddress", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/sub-account/subAccountApi/ipRestriction/ipList", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String managedSubDeposit(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "toEmail", String.class);
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/managed-subaccount/deposit", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String managedSubDetails(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/managed-subaccount/asset", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String managedSubWithdraw(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "fromEmail", String.class);
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/managed-subaccount/withdraw", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String managedSubAccountSnapshot(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "email", String.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/managed-subaccount/accountSnapshot", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

