/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.HmacSignatureGenerator;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.SignatureGenerator;
import java.util.LinkedHashMap;

public class Trade {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String TEST_NEW_ORDER = "/api/v3/order/test";
    private final String ORDER = "/api/v3/order";
    private final String ALL_OPEN_ORDERS = "/api/v3/openOrders";
    private final String CANCEL_REPLACE = "/api/v3/order/cancelReplace";
    private final String ALL_ORDERS = "/api/v3/allOrders";
    private final String OCO_ORDER = "/api/v3/order/oco";
    private final String OCO_LIST = "/api/v3/orderList";
    private final String ALL_OCO_LIST = "/api/v3/allOrderList";
    private final String ALL_OPEN_OCO_LIST = "/api/v3/openOrderList";
    private final String ACCOUNT_INFO = "/api/v3/account";
    private final String ACCOUNT_TRADES = "/api/v3/myTrades";
    private final String RATE_LIMIT = "/api/v3/rateLimit/order";

    public Trade(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public Trade(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String testNewOrder(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/order/test", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String newOrder(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/order", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String cancelOrder(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/order", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String cancelOpenOrders(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/openOrders", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String getOrder(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/order", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String cancelReplace(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        ParameterChecker.checkParameter(parameters, "cancelReplaceMode", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/order/cancelReplace", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String getOpenOrders(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/openOrders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getOrders(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/allOrders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String ocoOrder(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "quantity");
        ParameterChecker.checkRequiredParameter(parameters, "price");
        ParameterChecker.checkRequiredParameter(parameters, "stopPrice");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/order/oco", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String cancelOCO(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/orderList", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String getOCOOrder(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/orderList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getOCOOrders(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/allOrderList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getOpenOCOOrders(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/openOrderList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String account(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/account", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String myTrades(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/myTrades", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String rateLimitOrder(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/rateLimit/order", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

