/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import java.util.LinkedHashMap;

public class UserData {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String SPOT_LISTEN_KEY = "/api/v3/userDataStream";
    private final String MARGIN_LISTEN_KEY = "/sapi/v1/userDataStream";
    private final String ISOLATED_LISTEN_KEY = "/sapi/v1/userDataStream/isolated";

    public UserData(String baseUrl, String apiKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String createListenKey() {
        return this.requestHandler.sendWithApiKeyRequest(this.baseUrl, "/api/v3/userDataStream", null, HttpMethod.POST, this.showLimitUsage);
    }

    public String extendListenKey(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "listenKey", String.class);
        return this.requestHandler.sendWithApiKeyRequest(this.baseUrl, "/api/v3/userDataStream", parameters, HttpMethod.PUT, this.showLimitUsage);
    }

    public String closeListenKey(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "listenKey", String.class);
        return this.requestHandler.sendWithApiKeyRequest(this.baseUrl, "/api/v3/userDataStream", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String createMarginListenKey() {
        return this.requestHandler.sendWithApiKeyRequest(this.baseUrl, "/sapi/v1/userDataStream", null, HttpMethod.POST, this.showLimitUsage);
    }

    public String extendMarginListenKey(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "listenKey", String.class);
        return this.requestHandler.sendWithApiKeyRequest(this.baseUrl, "/sapi/v1/userDataStream", parameters, HttpMethod.PUT, this.showLimitUsage);
    }

    public String closeMarginListenKey(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "listenKey", String.class);
        return this.requestHandler.sendWithApiKeyRequest(this.baseUrl, "/sapi/v1/userDataStream", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String createIsolatedMarginListenKey(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendWithApiKeyRequest(this.baseUrl, "/sapi/v1/userDataStream/isolated", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String extendIsolatedMarginListenKey(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "listenKey", String.class);
        return this.requestHandler.sendWithApiKeyRequest(this.baseUrl, "/sapi/v1/userDataStream/isolated", parameters, HttpMethod.PUT, this.showLimitUsage);
    }

    public String closeIsolatedMarginListenKey(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "listenKey", String.class);
        return this.requestHandler.sendWithApiKeyRequest(this.baseUrl, "/sapi/v1/userDataStream/isolated", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }
}

