/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.utils;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.enums.RequestType;
import com.binance.connector.client.exceptions.BinanceConnectorException;
import com.binance.connector.client.utils.HmacSignatureGenerator;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestBuilder;
import com.binance.connector.client.utils.ResponseHandler;
import com.binance.connector.client.utils.RsaSignatureGenerator;
import com.binance.connector.client.utils.SignatureGenerator;
import com.binance.connector.client.utils.UrlBuilder;
import java.util.LinkedHashMap;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler {
    private final String apiKey;
    private final SignatureGenerator signatureGenerator;
    private static final Logger logger = LoggerFactory.getLogger(RequestHandler.class);
    private final ProxyAuth proxy;

    public RequestHandler(String apiKey, ProxyAuth proxy) {
        this(apiKey, null, proxy);
    }

    public RequestHandler(String apiKey, SignatureGenerator signatureGenerator, ProxyAuth proxy) {
        this.apiKey = apiKey;
        this.signatureGenerator = signatureGenerator;
        this.proxy = proxy;
    }

    private String sendApiRequest(String baseUrl, String urlPath, String signature, LinkedHashMap<String, Object> parameters, HttpMethod httpMethod, RequestType requestType, boolean showLimitUsage) {
        Request request;
        String fullUrl = UrlBuilder.buildFullUrl(baseUrl, urlPath, parameters, signature);
        logger.info("{} {}", (Object)httpMethod, (Object)fullUrl);
        switch (requestType) {
            case PUBLIC: {
                request = RequestBuilder.buildPublicRequest(fullUrl, httpMethod);
                break;
            }
            case WITH_API_KEY: 
            case SIGNED: {
                request = RequestBuilder.buildApiKeyRequest(fullUrl, httpMethod, this.apiKey);
                break;
            }
            default: {
                throw new BinanceConnectorException("[RequestHandler] Invalid request type: " + (Object)((Object)requestType));
            }
        }
        return ResponseHandler.handleResponse(request, showLimitUsage, this.proxy);
    }

    public String sendPublicRequest(String baseUrl, String urlPath, LinkedHashMap<String, Object> parameters, HttpMethod httpMethod, boolean showLimitUsage) {
        return this.sendApiRequest(baseUrl, urlPath, null, parameters, httpMethod, RequestType.PUBLIC, showLimitUsage);
    }

    public String sendWithApiKeyRequest(String baseUrl, String urlPath, LinkedHashMap<String, Object> parameters, HttpMethod httpMethod, boolean showLimitUsage) {
        if (null == this.apiKey || this.apiKey.isEmpty()) {
            throw new BinanceConnectorException("[RequestHandler] API key cannot be null or empty!");
        }
        return this.sendApiRequest(baseUrl, urlPath, null, parameters, httpMethod, RequestType.WITH_API_KEY, showLimitUsage);
    }

    public String sendSignedRequest(String baseUrl, String urlPath, LinkedHashMap<String, Object> parameters, HttpMethod httpMethod, boolean showLimitUsage) {
        if (this.signatureGenerator.getClass() == HmacSignatureGenerator.class && null == this.apiKey || this.apiKey.isEmpty()) {
            throw new BinanceConnectorException("[RequestHandler] Secret key/API key cannot be null or empty!");
        }
        if (this.signatureGenerator.getClass() == RsaSignatureGenerator.class && null == this.apiKey || this.apiKey.isEmpty()) {
            throw new BinanceConnectorException("[RequestHandler] Private key/API key cannot be null or empty!");
        }
        parameters.put("timestamp", UrlBuilder.buildTimestamp());
        String queryString = UrlBuilder.joinQueryParameters(parameters);
        String signature = this.signatureGenerator.getSignature(queryString);
        return this.sendApiRequest(baseUrl, urlPath, signature, parameters, httpMethod, RequestType.SIGNED, showLimitUsage);
    }
}

