/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl;

import com.binance.connector.client.SpotClient;
import com.binance.connector.client.impl.spot.BSwap;
import com.binance.connector.client.impl.spot.Blvt;
import com.binance.connector.client.impl.spot.C2C;
import com.binance.connector.client.impl.spot.Convert;
import com.binance.connector.client.impl.spot.CryptoLoans;
import com.binance.connector.client.impl.spot.Fiat;
import com.binance.connector.client.impl.spot.Futures;
import com.binance.connector.client.impl.spot.GiftCard;
import com.binance.connector.client.impl.spot.Margin;
import com.binance.connector.client.impl.spot.Market;
import com.binance.connector.client.impl.spot.Mining;
import com.binance.connector.client.impl.spot.NFT;
import com.binance.connector.client.impl.spot.Pay;
import com.binance.connector.client.impl.spot.PortfolioMargin;
import com.binance.connector.client.impl.spot.Rebate;
import com.binance.connector.client.impl.spot.Savings;
import com.binance.connector.client.impl.spot.Staking;
import com.binance.connector.client.impl.spot.SubAccount;
import com.binance.connector.client.impl.spot.Trade;
import com.binance.connector.client.impl.spot.UserData;
import com.binance.connector.client.impl.spot.Wallet;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;

public class SpotClientImpl
implements SpotClient {
    private final String apiKey;
    private final SignatureGenerator signatureGenerator;
    private final String baseUrl;
    private boolean showLimitUsage = false;
    private ProxyAuth proxy = null;

    public SpotClientImpl() {
        this("https://api.binance.com");
    }

    public SpotClientImpl(String baseUrl) {
        this("", (SignatureGenerator)null, baseUrl);
    }

    public SpotClientImpl(String baseUrl, boolean showLimitUsage) {
        this(baseUrl);
        this.showLimitUsage = showLimitUsage;
    }

    public SpotClientImpl(String apiKey, String secretKey) {
        this(apiKey, secretKey, "https://api.binance.com");
    }

    public SpotClientImpl(String apiKey, String secretKey, String baseUrl) {
        this(apiKey, new HmacSignatureGenerator(secretKey), baseUrl);
    }

    public SpotClientImpl(String apiKey, SignatureGenerator signatureGenerator, String baseUrl) {
        this.apiKey = apiKey;
        this.signatureGenerator = signatureGenerator;
        this.baseUrl = baseUrl;
    }

    @Override
    public void setShowLimitUsage(boolean showLimitUsage) {
        this.showLimitUsage = showLimitUsage;
    }

    @Override
    public void setProxy(ProxyAuth proxy) {
        this.proxy = proxy;
    }

    @Override
    public void unsetProxy() {
        this.proxy = null;
    }

    @Override
    public Blvt createBlvt() {
        return new Blvt(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public BSwap createBswap() {
        return new BSwap(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public C2C createC2C() {
        return new C2C(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public Convert createConvert() {
        return new Convert(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public CryptoLoans createCryptoLoans() {
        return new CryptoLoans(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public Fiat createFiat() {
        return new Fiat(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public Futures createFutures() {
        return new Futures(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public GiftCard createGiftCard() {
        return new GiftCard(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public Margin createMargin() {
        return new Margin(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public Market createMarket() {
        return new Market(this.baseUrl, this.apiKey, this.showLimitUsage, this.proxy);
    }

    @Override
    public Mining createMining() {
        return new Mining(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public NFT createNFT() {
        return new NFT(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public Pay createPay() {
        return new Pay(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public PortfolioMargin createPortfolioMargin() {
        return new PortfolioMargin(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public Rebate createRebate() {
        return new Rebate(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public Savings createSavings() {
        return new Savings(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public Staking createStaking() {
        return new Staking(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public SubAccount createSubAccount() {
        return new SubAccount(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public Trade createTrade() {
        return new Trade(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }

    @Override
    public UserData createUserData() {
        return new UserData(this.baseUrl, this.apiKey, this.showLimitUsage, this.proxy);
    }

    @Override
    public Wallet createWallet() {
        return new Wallet(this.baseUrl, this.apiKey, this.signatureGenerator, this.showLimitUsage, this.proxy);
    }
}

