/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class Mining {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String ALGO = "/sapi/v1/mining/pub/algoList";
    private final String COIN_NAME = "/sapi/v1/mining/pub/coinList";
    private final String DETAIL_MINER_LIST = "/sapi/v1/mining/worker/detail";
    private final String MINER_LIST = "/sapi/v1/mining/worker/list";
    private final String EARNING_LIST = "/sapi/v1/mining/payment/list";
    private final String BONUS_LIST = "/sapi/v1/mining/payment/other";
    private final String HASHRATE_RESALE_LIST = "/sapi/v1/mining/hash-transfer/config/details/list";
    private final String HASHRATE_RESALE_DETAIL = "/sapi/v1/mining/hash-transfer/profit/details";
    private final String HASHRATE_RESALE_REQUEST = "/sapi/v1/mining/hash-transfer/config";
    private final String CANCEL_HASHRATE_RESALE_CONFIG = "/sapi/v1/mining/hash-transfer/config/cancel";
    private final String STATSTICS_LIST = "/sapi/v1/mining/statistics/user/status";
    private final String ACCOUNT_LIST = "/sapi/v1/mining/statistics/user/list";
    private final String ACCOUNT_EARNING = "/sapi/v1/mining/payment/uid";

    public Mining(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public Mining(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String algorithm(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/mining/pub/algoList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String coinName(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/mining/pub/coinList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String detailMinerList(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "algo", String.class);
        ParameterChecker.checkParameter(parameters, "userName", String.class);
        ParameterChecker.checkParameter(parameters, "workerName", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/mining/worker/detail", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String minerList(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "algo", String.class);
        ParameterChecker.checkParameter(parameters, "userName", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/mining/worker/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String earningList(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "algo", String.class);
        ParameterChecker.checkParameter(parameters, "userName", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/mining/payment/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String bonusList(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "algo", String.class);
        ParameterChecker.checkParameter(parameters, "userName", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/mining/payment/other", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String hashrateResaleList(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/mining/hash-transfer/config/details/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String hashrateResaleDetail(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "configId", Integer.class);
        ParameterChecker.checkParameter(parameters, "userName", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/mining/hash-transfer/profit/details", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String hashrateResaleRequest(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "userName", String.class);
        ParameterChecker.checkParameter(parameters, "algo", String.class);
        ParameterChecker.checkParameter(parameters, "endDate", Long.class);
        ParameterChecker.checkParameter(parameters, "startDate", Long.class);
        ParameterChecker.checkParameter(parameters, "toPoolUser", String.class);
        ParameterChecker.checkParameter(parameters, "hashRate", Long.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/mining/hash-transfer/config", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String cancelHashrateResaleConfig(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "configId", Integer.class);
        ParameterChecker.checkParameter(parameters, "userName", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/mining/hash-transfer/config/cancel", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String statsticsList(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "algo", String.class);
        ParameterChecker.checkParameter(parameters, "userName", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/mining/statistics/user/status", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String accountList(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "algo", String.class);
        ParameterChecker.checkParameter(parameters, "userName", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/mining/statistics/user/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String accountEarning(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "algo", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/mining/payment/uid", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

