/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class PortfolioMargin {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String ACCOUNT = "/sapi/v1/portfolio/account";
    private final String COLLATERAL_RATE = "/sapi/v1/portfolio/collateralRate";
    private final String PM_LOAN = "/sapi/v1/portfolio/pmLoan";
    private final String REPAY = "/sapi/v1/portfolio/repay";

    public PortfolioMargin(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public PortfolioMargin(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String getAccount(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/account", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String collateralRate(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/collateralRate", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String bankruptcyLoanRecord(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/pmLoan", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String repay(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/repay", parameters, HttpMethod.POST, this.showLimitUsage);
    }
}

