/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class Savings {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String ACTIVITY_PROJECT = "/sapi/v1/lending/project/list";
    private final String PURCHASE_ACTIVITY = "/sapi/v1/lending/customizedFixed/purchase";
    private final String PROJECT_POSITION = "/sapi/v1/lending/project/position/list";
    private final String CHANGE_TO_DAILY_POSITION = "/sapi/v1/lending/positionChanged";

    public Savings(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public Savings(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String projectList(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/project/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String purchaseProject(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "projectId", String.class);
        ParameterChecker.checkParameter(parameters, "lot", Long.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/customizedFixed/purchase", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String projectPosition(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/project/position/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String changeToDailyPosition(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "projectId", String.class);
        ParameterChecker.checkParameter(parameters, "lot", Long.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/positionChanged", parameters, HttpMethod.POST, this.showLimitUsage);
    }
}

