/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;

public class Wallet {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String SYSTEM_STATUS = "/sapi/v1/system/status";
    private final String COIN_INFO = "/sapi/v1/capital/config/getall";
    private final String ACC_SNAP = "/sapi/v1/accountSnapshot";
    private final String DISABLE_FAST = "/sapi/v1/account/disableFastWithdrawSwitch";
    private final String ENABLE_FAST = "/sapi/v1/account/enableFastWithdrawSwitch";
    private final String WITHDRAW = "/sapi/v1/capital/withdraw/apply";
    private final String DEPOSIT_HIST = "/sapi/v1/capital/deposit/hisrec";
    private final String WITHDRAW_HIST = "/sapi/v1/capital/withdraw/history";
    private final String DEPOSIT_ADD = "/sapi/v1/capital/deposit/address";
    private final String ACC_STATUS = "/sapi/v1/account/status";
    private final String API_TRADE_STATUS = "/sapi/v1/account/apiTradingStatus";
    private final String DUST_LOG = "/sapi/v1/asset/dribblet";
    private final String BNB_CONVERTABLE_ASSETS = "/sapi/v1/asset/dust-btc";
    private final String DUST_TRANSFER = "/sapi/v1/asset/dust";
    private final String ASSET_DIVIDEND = "/sapi/v1/asset/assetDividend";
    private final String ASSET_DETAIL = "/sapi/v1/asset/assetDetail";
    private final String TRADE_FEE = "/sapi/v1/asset/tradeFee";
    private final String UNIVERSAL_TRANSFER = "/sapi/v1/asset/transfer";
    private final String FUNDING_WALLET = "/sapi/v1/asset/get-funding-asset";
    private final String API_PERMISSION = "/sapi/v1/account/apiRestrictions";
    private final String USER_ASSET = "/sapi/v3/asset/getUserAsset";
    private final String BUSD_CONVERT = "/sapi/v1/asset/convert-transfer";
    private final String BUSD_CONVERT_HISTORY = "/sapi/v1/asset/convert-transfer/queryByPage";
    private final String CLOUD_MINING_HISTORY = "/sapi/v1/asset/ledger-transfer/cloud-mining/queryByPage";

    public Wallet(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public Wallet(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String systemStatus() {
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/sapi/v1/system/status", null, HttpMethod.GET, this.showLimitUsage);
    }

    public String coinInfo(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/capital/config/getall", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String accountSnapshot(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/accountSnapshot", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String disableFastWithdraw(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/account/disableFastWithdrawSwitch", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String enableFastWithdraw(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/account/enableFastWithdrawSwitch", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String withdraw(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "coin", String.class);
        ParameterChecker.checkParameter(parameters, "address", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/capital/withdraw/apply", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String depositHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/capital/deposit/hisrec", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String withdrawHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/capital/withdraw/history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String depositAddress(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "coin", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/capital/deposit/address", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String accountStatus(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/account/status", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String apiTradingStatus(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/account/apiTradingStatus", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String dustLog(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/asset/dribblet", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String bnbConvertableAssets(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/asset/dust-btc", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String dustTransfer(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", ArrayList.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/asset/dust", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String assetDividend(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/asset/assetDividend", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String assetDetail(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/asset/assetDetail", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String tradeFee(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/asset/tradeFee", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String universalTransfer(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "type", String.class);
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/asset/transfer", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String queryUniversalTransfer(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/asset/transfer", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String fundingWallet(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/asset/get-funding-asset", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String apiPermission(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/account/apiRestrictions", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getUserAsset(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v3/asset/getUserAsset", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String busdConvert(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "clientTranId", String.class);
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkParameter(parameters, "amount", BigDecimal.class);
        ParameterChecker.checkParameter(parameters, "targetAsset", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/asset/convert-transfer", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String busdConvertHistory(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "startTime", Long.class);
        ParameterChecker.checkParameter(parameters, "endTime", Long.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/asset/convert-transfer/queryByPage", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String cloudMiningHistory(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "startTime", Long.class);
        ParameterChecker.checkParameter(parameters, "endTime", Long.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/asset/ledger-transfer/cloud-mining/queryByPage", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

