/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.websocketapi;

import com.binance.connector.client.utils.JSONParser;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.websocketapi.WebSocketApiRequestHandler;
import org.json.JSONObject;

public class WebSocketApiAccount {
    private WebSocketApiRequestHandler handler;

    public WebSocketApiAccount(WebSocketApiRequestHandler handler) {
        this.handler = handler;
    }

    public void accountStatus(JSONObject parameters) {
        this.handler.signedRequest("account.status", parameters);
    }

    public void accountRateLimitsOrders(JSONObject parameters) {
        this.handler.signedRequest("account.rateLimits.orders", parameters);
    }

    public void accountAllOrders(String symbol, JSONObject parameters) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        this.handler.signedRequest("allOrders", parameters);
    }

    public void accountAllOcoOrders(JSONObject parameters) {
        this.handler.signedRequest("allOrderLists", parameters);
    }

    public void accountTradeHistory(String symbol, JSONObject parameters) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        this.handler.signedRequest("myTrades", parameters);
    }

    public void accountPreventedMatches(String symbol, JSONObject parameters) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        ParameterChecker.checkOneOfParametersRequired(parameters, "preventedMatchId", "orderId");
        ParameterChecker.checkOnlyOneOfParameters(parameters, "preventedMatchId", "orderId");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        this.handler.signedRequest("myPreventedMatches", parameters);
    }
}

