/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.websocketapi;

import com.binance.connector.client.utils.JSONParser;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.websocketapi.WebSocketApiRequestHandler;
import org.json.JSONObject;

public class WebSocketApiMarket {
    private WebSocketApiRequestHandler handler;

    public WebSocketApiMarket(WebSocketApiRequestHandler handler) {
        this.handler = handler;
    }

    public void depth(String symbol, JSONObject parameters) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        this.handler.publicRequest("depth", parameters);
    }

    public void recentTrades(String symbol, JSONObject parameters) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        this.handler.publicRequest("trades.recent", parameters);
    }

    public void historicalTrades(String symbol, JSONObject parameters) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        this.handler.apiRequest("trades.historical", parameters);
    }

    public void aggTrades(String symbol, JSONObject parameters) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        this.handler.publicRequest("trades.aggregate", parameters);
    }

    public void klines(String symbol, String interval, JSONObject parameters) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        ParameterChecker.checkParameterType(interval, String.class, "interval");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        parameters = JSONParser.addKeyValue(parameters, "interval", interval);
        this.handler.publicRequest("klines", parameters);
    }

    public void uiKlines(String symbol, String interval, JSONObject parameters) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        ParameterChecker.checkParameterType(interval, String.class, "interval");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        parameters = JSONParser.addKeyValue(parameters, "interval", interval);
        this.handler.publicRequest("uiKlines", parameters);
    }

    public void avgPrice(String symbol, JSONObject parameters) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        this.handler.publicRequest("avgPrice", parameters);
    }

    public void ticker24H(JSONObject parameters) {
        ParameterChecker.checkOnlyOneOfParameters(parameters, "symbol", "symbols");
        this.handler.publicRequest("ticker.24hr", parameters);
    }

    public void ticker(JSONObject parameters) {
        ParameterChecker.checkOnlyOneOfParameters(parameters, "symbol", "symbols");
        ParameterChecker.checkOneOfParametersRequired(parameters, "symbol", "symbols");
        this.handler.publicRequest("ticker", parameters);
    }

    public void tickerPrice(JSONObject parameters) {
        ParameterChecker.checkOnlyOneOfParameters(parameters, "symbol", "symbols");
        this.handler.publicRequest("ticker.price", parameters);
    }

    public void tickerBook(JSONObject parameters) {
        ParameterChecker.checkOnlyOneOfParameters(parameters, "symbol", "symbols");
        this.handler.publicRequest("ticker.book", parameters);
    }
}

