/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class AutoInvest {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String TARGET_ASSET_LIST = "/sapi/v1/lending/auto-invest/target-asset/list";
    private final String TARGET_ASSET_ROI_LIST = "/sapi/v1/lending/auto-invest/target-asset/roi/list";
    private final String ALL_SOURCE_AND_TARGET_ASSETS = "/sapi/v1/lending/auto-invest/all/asset";
    private final String SOURCE_ASSET_LIST = "/sapi/v1/lending/auto-invest/source-asset/list";
    private final String CHANGE_PLAN_STATUS = "/sapi/v1/lending/auto-invest/plan/edit-status";
    private final String PLANS = "/sapi/v1/lending/auto-invest/plan/list";
    private final String HOLDING_PLAN = "/sapi/v1/lending/auto-invest/plan/id";
    private final String PLAN_SUBSCRIPTIONS_HISTORY = "/sapi/v1/lending/auto-invest/history/list";
    private final String INDEX_INFO = "/sapi/v1/lending/auto-invest/index/info";
    private final String INDEX_USER_SUMMARY = "/sapi/v1/lending/auto-invest/index/user-summary";
    private final String ONE_TIME_TRANSACTION = "/sapi/v1/lending/auto-invest/one-off";
    private final String ONE_TIME_TRANSACTION_STATUS = "/sapi/v1/lending/auto-invest/one-off/status";
    private final String REDEEM_INDEX_PLAN = "/sapi/v1/lending/auto-invest/redeem";
    private final String INDEX_LINKED_PLAN_REDEMPTION_HISTORY = "/sapi/v1/lending/auto-invest/redeem/history";
    private final String INDEX_LINKED_PLAN_REBALANCE_DETAILS = "/sapi/v1/lending/auto-invest/rebalance/history";

    public AutoInvest(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public AutoInvest(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String targetAssetList(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/auto-invest/target-asset/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String targetAssetRoiList(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "targetAsset", String.class);
        ParameterChecker.checkParameter(parameters, "hisRoiType", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/auto-invest/target-asset/roi/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String allSourceAndTargetAssets(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/auto-invest/all/asset", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String sourceAssetList(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "usageType", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/auto-invest/source-asset/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String changePlanStatus(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "planId", Long.class);
        ParameterChecker.checkParameter(parameters, "status", String.class);
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/sapi/v1/lending/auto-invest/plan/edit-status", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String plansList(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "planType", String.class);
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/sapi/v1/lending/auto-invest/plan/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String holdingPlan(Map<String, Object> parameters) {
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/sapi/v1/lending/auto-invest/plan/id", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String planSubsHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/sapi/v1/lending/auto-invest/history/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String indexInfo(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "indexId", Long.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/auto-invest/index/info", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String userIndexPlans(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "indexId", Long.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/auto-invest/index/user-summary", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String submitOneTimeTransaction(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "sourceType", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "subscriptionAmount");
        ParameterChecker.checkParameter(parameters, "sourceAsset", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/auto-invest/one-off", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String oneTimeTransactionStatus(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "transactionId", Long.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/auto-invest/one-off/status", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String redeemIndexPlan(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "indexId", Long.class);
        ParameterChecker.checkParameter(parameters, "redemptionPercentage", Integer.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/auto-invest/redeem", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String indexPlanRedeemHistory(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "requestId", Long.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/auto-invest/redeem/history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String indexPlanRebalanceInfo(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/lending/auto-invest/rebalance/history", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

