/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class Trade {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String TEST_NEW_ORDER = "/api/v3/order/test";
    private final String ORDER = "/api/v3/order";
    private final String ALL_OPEN_ORDERS = "/api/v3/openOrders";
    private final String CANCEL_REPLACE = "/api/v3/order/cancelReplace";
    private final String ALL_ORDERS = "/api/v3/allOrders";
    private final String OCO_LIST = "/api/v3/orderList";
    private final String ALL_OCO_LIST = "/api/v3/allOrderList";
    private final String ALL_OPEN_OCO_LIST = "/api/v3/openOrderList";
    private final String ACCOUNT_INFO = "/api/v3/account";
    private final String ACCOUNT_TRADES = "/api/v3/myTrades";
    private final String RATE_LIMIT = "/api/v3/rateLimit/order";
    private final String PREVENTED_MATCHES = "/api/v3/myPreventedMatches";
    private final String SOR_ALLOCATIONS = "/api/v3/myAllocations";
    private final String COMMISSION = "/api/v3/account/commission";
    private final String SOR_ORDER = "/api/v3/sor/order";
    private final String TEST_SOR_ORDER = "/api/v3/sor/order/test";

    public Trade(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public Trade(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String testNewOrder(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/order/test", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String newOrder(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/order", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String cancelOrder(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/order", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String cancelOpenOrders(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/openOrders", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String getOrder(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/order", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String cancelReplace(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        ParameterChecker.checkParameter(parameters, "cancelReplaceMode", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/order/cancelReplace", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String getOpenOrders(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/openOrders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getOrders(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/allOrders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String cancelOCO(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/orderList", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String getOCOOrder(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/orderList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getOCOOrders(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/allOrderList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getOpenOCOOrders(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/openOrderList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String account(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/account", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String myTrades(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/myTrades", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String rateLimitOrder(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/rateLimit/order", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String preventedMatches(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/myPreventedMatches", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String sorAllocations(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/myAllocations", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String commission(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/account/commission", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String sorOrder(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "quantity");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/sor/order", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String testSorOrder(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "quantity");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/api/v3/sor/order/test", parameters, HttpMethod.POST, this.showLimitUsage);
    }
}

