/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.utils;

import com.binance.connector.client.exceptions.BinanceConnectorException;
import com.binance.connector.client.utils.websocketcallback.WebSocketClosedCallback;
import com.binance.connector.client.utils.websocketcallback.WebSocketClosingCallback;
import com.binance.connector.client.utils.websocketcallback.WebSocketFailureCallback;
import com.binance.connector.client.utils.websocketcallback.WebSocketMessageCallback;
import com.binance.connector.client.utils.websocketcallback.WebSocketOpenCallback;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnection
extends WebSocketListener {
    private static final AtomicInteger connectionCounter = new AtomicInteger(0);
    private static final int NORMAL_CLOSURE_STATUS = 1000;
    private static final Logger logger = LoggerFactory.getLogger(WebSocketConnection.class);
    private static OkHttpClient client;
    private static boolean sessionStatus;
    private final int connectionId;
    private final Object mutex;
    private final Request request;
    private final String streamName;
    private final WebSocketOpenCallback onOpenCallback;
    private final WebSocketMessageCallback onMessageCallback;
    private final WebSocketClosingCallback onClosingCallback;
    private final WebSocketClosedCallback onClosedCallback;
    private final WebSocketFailureCallback onFailureCallback;
    private WebSocket webSocket;

    public WebSocketConnection(WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback, Request request, OkHttpClient client) {
        this.onOpenCallback = onOpenCallback;
        this.onMessageCallback = onMessageCallback;
        this.onClosingCallback = onClosingCallback;
        this.onClosedCallback = onClosedCallback;
        this.onFailureCallback = onFailureCallback;
        this.connectionId = connectionCounter.incrementAndGet();
        this.request = request;
        this.streamName = request.url().host() + request.url().encodedPath();
        this.webSocket = null;
        this.mutex = new Object();
        WebSocketConnection.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.mutex;
        synchronized (object) {
            if (null == this.webSocket) {
                logger.info("[Connection {}] Connecting to {}", (Object)this.connectionId, (Object)this.streamName);
                this.webSocket = client.newWebSocket(this.request, (WebSocketListener)this);
            } else {
                logger.info("[Connection {}] is already connected to {}", (Object)this.connectionId, (Object)this.streamName);
            }
        }
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public boolean getSessionStatus() {
        return sessionStatus;
    }

    public void send(String message) {
        if (null == this.webSocket) {
            throw new BinanceConnectorException("No WebSocket connection. Please connect first!");
        }
        this.webSocket.send(message);
    }

    public void close() {
        if (null != this.webSocket) {
            logger.info("[Connection {}] Closing connection to {}", (Object)this.connectionId, (Object)this.streamName);
            this.webSocket.close(1000, null);
        }
    }

    public void onOpen(WebSocket ws, Response response) {
        logger.info("[Connection {}] Connected to Server", (Object)this.connectionId);
        this.onOpenCallback.onOpen(response);
    }

    public void onClosing(WebSocket ws, int code, String reason) {
        super.onClosing(ws, code, reason);
        this.onClosingCallback.onClosing(code, reason);
    }

    public void onClosed(WebSocket ws, int code, String reason) {
        super.onClosed(ws, code, reason);
        this.onClosedCallback.onClosed(code, reason);
    }

    public void onMessage(WebSocket ws, String text) {
        if (text.contains("authorizedSince")) {
            JSONObject result = new JSONObject(text).getJSONObject("result");
            sessionStatus = !result.isNull("authorizedSince");
        }
        this.onMessageCallback.onMessage(text);
    }

    public void onFailure(WebSocket ws, Throwable t, Response response) {
        logger.error("[Connection {}] Failure", (Object)this.connectionId, (Object)t);
        this.onFailureCallback.onFailure(t, response);
    }
}

