/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class SimpleEarn {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String FLEXIBLE_PRODUCT_LIST = "/sapi/v1/simple-earn/flexible/list";
    private final String LOCKED_PRODUCT_LIST = "/sapi/v1/simple-earn/locked/list";
    private final String SUBSCRIBE_FLEXIBLE_PRODUCT = "/sapi/v1/simple-earn/flexible/subscribe";
    private final String SUBSCRIBE_LOCKED_PRODUCT = "/sapi/v1/simple-earn/locked/subscribe";
    private final String REDEEM_FLEXIBLE_PRODUCT = "/sapi/v1/simple-earn/flexible/redeem";
    private final String REDEEM_LOCKED_PRODUCT = "/sapi/v1/simple-earn/locked/redeem";
    private final String FLEXIBLE_PRODUCT_POSITION = "/sapi/v1/simple-earn/flexible/position";
    private final String LOCKED_PRODUCT_POSITION = "/sapi/v1/simple-earn/locked/position";
    private final String SIMPLE_ACCOUNT = "/sapi/v1/simple-earn/account";
    private final String FLEXIBLE_SUBSCRIPTION_RECORD = "/sapi/v1/simple-earn/flexible/history/subscriptionRecord";
    private final String LOCKED_SUBSCRIPTION_RECORD = "/sapi/v1/simple-earn/locked/history/subscriptionRecord";
    private final String FLEXIBLE_REDEMPTION_RECORD = "/sapi/v1/simple-earn/flexible/history/redemptionRecord";
    private final String LOCKED_REDEMPTION_RECORD = "/sapi/v1/simple-earn/locked/history/redemptionRecord";
    private final String FLEXIBLE_REWARDS_HISTORY = "/sapi/v1/simple-earn/flexible/history/rewardsRecord";
    private final String LOCKED_REWARDS_HISTORY = "/sapi/v1/simple-earn/locked/history/rewardsRecord";
    private final String SET_FLEXIBLE_AUTO_SUBSCRIBE = "/sapi/v1/simple-earn/flexible/setAutoSubscribe";
    private final String SET_LOCKED_AUTO_SUBSCRIBE = "/sapi/v1/simple-earn/locked/setAutoSubscribe";
    private final String FLEXIBLE_PERSONAL_LEFT_QUOTA = "/sapi/v1/simple-earn/flexible/personalLeftQuota";
    private final String LOCKED_PERSONAL_LEFT_QUOTA = "/sapi/v1/simple-earn/locked/personalLeftQuota";
    private final String FLEXIBLE_SUBSCRIPTION_PREVIEW = "/sapi/v1/simple-earn/flexible/subscriptionPreview";
    private final String LOCKED_SUBSCRIPTION_PREVIEW = "/sapi/v1/simple-earn/locked/subscriptionPreview";
    private final String RATE_HISTORY = "/sapi/v1/simple-earn/flexible/history/rateHistory";
    private final String COLLATERAL_RECORD = "/sapi/v1/simple-earn/flexible/history/collateralRecord";

    public SimpleEarn(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public SimpleEarn(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String flexibleProductList(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/flexible/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String lockedProductList(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/locked/list", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String subscribeFlexibleProduct(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/flexible/subscribe", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String subscribeLockedProduct(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "projectId", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/locked/subscribe", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String redeemFlexibleProduct(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/flexible/redeem", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String redeemLockedProduct(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "positionId", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/locked/redeem", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String flexibleProductPosition(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/flexible/position", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String lockedProductPosition(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/locked/position", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String simpleAccount(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/account", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String flexibleSubscriptionRecord(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/flexible/history/subscriptionRecord", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String lockedSubscriptionRecord(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/locked/history/subscriptionRecord", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String flexibleRedemptionRecord(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/flexible/history/redemptionRecord", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String lockedRedemptionRecord(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/locked/history/redemptionRecord", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String flexibleRewardsHistory(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/flexible/history/rewardsRecord", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String lockedRewardsHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/locked/history/rewardsRecord", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String setFlexibleAutoSubscribe(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        ParameterChecker.checkParameter(parameters, "autoSubscribe", Boolean.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/flexible/setAutoSubscribe", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String setLockedAutoSubscribe(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "positionId", String.class);
        ParameterChecker.checkParameter(parameters, "autoSubscribe", Boolean.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/locked/setAutoSubscribe", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String flexiblePersonalLeftQuota(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/flexible/personalLeftQuota", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String lockedPersonalLeftQuota(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "projectId", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/locked/personalLeftQuota", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String flexibleSubscriptionPreview(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/flexible/subscriptionPreview", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String lockedSubscriptionPreview(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "projectId", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/locked/subscriptionPreview", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String rateHistory(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/flexible/history/rateHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String collateralRecord(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/simple-earn/flexible/history/collateralRecord", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

