/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.futures.client.impl;

import com.binance.connector.futures.client.impl.WebsocketClientImpl;
import com.binance.connector.futures.client.utils.ParameterChecker;
import com.binance.connector.futures.client.utils.RequestBuilder;
import com.binance.connector.futures.client.utils.WebSocketCallback;
import okhttp3.Request;

public class CMWebsocketClientImpl
extends WebsocketClientImpl {
    public CMWebsocketClientImpl() {
        super("wss://dstream.binance.com");
    }

    public CMWebsocketClientImpl(String baseUrl) {
        super(baseUrl);
    }

    public int indexPriceStream(String pair, int speed, WebSocketCallback onMessageCallback) {
        ParameterChecker.checkParameterType(pair, String.class, "pair");
        return this.indexPriceStream(pair, speed, this.getNoopCallback(), onMessageCallback, this.getNoopCallback(), this.getNoopCallback());
    }

    public int indexPriceStream(String pair, int speed, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(pair, String.class, "pair");
        Request request = null;
        int defaultSpeed = 3;
        request = speed == 3 ? RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@indexPrice", this.getBaseUrl(), pair.toLowerCase(), speed)) : RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@indexPrice@%ss", this.getBaseUrl(), pair.toLowerCase(), speed));
        return super.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    public int markPriceSymbolsPairStream(String pair, int speed, WebSocketCallback onMessageCallback) {
        ParameterChecker.checkParameterType(pair, String.class, "pair");
        return this.markPriceSymbolsPairStream(pair, speed, this.getNoopCallback(), onMessageCallback, this.getNoopCallback(), this.getNoopCallback());
    }

    public int markPriceSymbolsPairStream(String pair, int speed, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(pair, String.class, "pair");
        Request request = null;
        int defaultSpeed = 3;
        request = speed == 3 ? RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@markPrice", this.getBaseUrl(), pair.toLowerCase())) : RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@markPrice@%ss", this.getBaseUrl(), pair.toLowerCase(), speed));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    public int indexKlineCandlestick(String pair, String interval, WebSocketCallback onMessageCallback) {
        ParameterChecker.checkParameterType(pair, String.class, "pair");
        return this.indexKlineCandlestick(pair, interval, this.getNoopCallback(), onMessageCallback, this.getNoopCallback(), this.getNoopCallback());
    }

    public int indexKlineCandlestick(String pair, String interval, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(pair, String.class, "pair");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@indexPriceKline_%s", this.getBaseUrl(), pair.toLowerCase(), interval));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    public int markKlineCandlestick(String symbol, String interval, WebSocketCallback onMessageCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.markKlineCandlestick(symbol, interval, this.getNoopCallback(), onMessageCallback, this.getNoopCallback(), this.getNoopCallback());
    }

    public int markKlineCandlestick(String symbol, String interval, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@markPriceKline_%s", this.getBaseUrl(), symbol.toLowerCase(), interval));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }
}

