/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.futures.client.impl;

import com.binance.connector.futures.client.WebsocketClient;
import com.binance.connector.futures.client.utils.HttpClientSingleton;
import com.binance.connector.futures.client.utils.ParameterChecker;
import com.binance.connector.futures.client.utils.RequestBuilder;
import com.binance.connector.futures.client.utils.UrlBuilder;
import com.binance.connector.futures.client.utils.WebSocketCallback;
import com.binance.connector.futures.client.utils.WebSocketConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebsocketClientImpl
implements WebsocketClient {
    private final String baseUrl;
    private final Map<Integer, WebSocketConnection> connections = new HashMap<Integer, WebSocketConnection>();
    private final WebSocketCallback noopCallback = msg -> {};
    private static final Logger logger = LoggerFactory.getLogger(WebsocketClientImpl.class);

    public WebsocketClientImpl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public WebSocketCallback getNoopCallback() {
        return this.noopCallback;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public int aggTradeStream(String symbol, WebSocketCallback onMessageCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.aggTradeStream(symbol, this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int aggTradeStream(String symbol, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@aggTrade", this.baseUrl, symbol.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int markPriceStream(String symbol, int speed, WebSocketCallback onMessageCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.markPriceStream(symbol, speed, this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int markPriceStream(String symbol, int speed, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        Request request = null;
        int defaultSpeed = 3;
        request = speed == 3 ? RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@markPrice", this.baseUrl, symbol.toLowerCase())) : RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@markPrice@%ss", this.baseUrl, symbol.toLowerCase(), speed));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int klineStream(String symbol, String interval, WebSocketCallback onMessageCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.klineStream(symbol, interval, this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int klineStream(String symbol, String interval, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@kline_%s", this.baseUrl, symbol.toLowerCase(), interval));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int continuousKlineStream(String pair, String contractType, String interval, WebSocketCallback onMessageCallback) {
        ParameterChecker.checkParameterType(pair, String.class, "pair");
        return this.continuousKlineStream(pair, contractType, interval, this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int continuousKlineStream(String pair, String contractType, String interval, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(pair, String.class, "pair");
        ParameterChecker.checkParameterType(contractType, String.class, "contractType");
        ParameterChecker.checkParameterType(interval, String.class, "interval");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s_%s@continuousKline_%s", this.baseUrl, pair.toLowerCase(), contractType, interval));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int miniTickerStream(String symbol, WebSocketCallback onMessageCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.miniTickerStream(symbol, this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int miniTickerStream(String symbol, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@miniTicker", this.baseUrl, symbol.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int allMiniTickerStream(WebSocketCallback onMessageCallback) {
        return this.allMiniTickerStream(this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int allMiniTickerStream(WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/!miniTicker@arr", this.baseUrl));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int symbolTicker(String symbol, WebSocketCallback onMessageCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.symbolTicker(symbol, this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int symbolTicker(String symbol, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@ticker", this.baseUrl, symbol.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int allTickerStream(WebSocketCallback onMessageCallback) {
        return this.allTickerStream(this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int allTickerStream(WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/!ticker@arr", this.baseUrl));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int bookTicker(String symbol, WebSocketCallback onMessageCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.bookTicker(symbol, this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int bookTicker(String symbol, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@bookTicker", this.baseUrl, symbol.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int allBookTickerStream(WebSocketCallback onMessageCallback) {
        return this.allBookTickerStream(this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int allBookTickerStream(WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/!bookTicker", this.baseUrl));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int forceOrderStream(String symbol, WebSocketCallback onMessageCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.forceOrderStream(symbol, this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int forceOrderStream(String symbol, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@forceOrder", this.baseUrl, symbol.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int allForceOrderStream(WebSocketCallback onMessageCallback) {
        return this.allForceOrderStream(this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int allForceOrderStream(WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/!forceOrder@arr", this.baseUrl));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int partialDepthStream(String symbol, int levels, int speed, WebSocketCallback onMessageCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.partialDepthStream(symbol, levels, speed, this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int partialDepthStream(String symbol, int levels, int speed, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = null;
        int defaultSpeed = 250;
        request = speed == 250 ? RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@depth%s", this.baseUrl, symbol.toLowerCase(), levels)) : RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@depth%s@%sms", this.baseUrl, symbol.toLowerCase(), levels, speed));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int diffDepthStream(String symbol, int speed, WebSocketCallback onMessageCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.diffDepthStream(symbol, speed, this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int diffDepthStream(String symbol, int speed, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = null;
        int defaultSpeed = 250;
        request = speed == 250 ? RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@depth", this.baseUrl, symbol.toLowerCase(), speed)) : RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@depth@%sms", this.baseUrl, symbol.toLowerCase(), speed));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int listenUserStream(String listenKey, WebSocketCallback onMessageCallback) {
        return this.listenUserStream(listenKey, this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int listenUserStream(String listenKey, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s", this.baseUrl, listenKey));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int combineStreams(ArrayList<String> streams, WebSocketCallback onMessageCallback) {
        return this.combineStreams(streams, this.noopCallback, onMessageCallback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int combineStreams(ArrayList<String> streams, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        String url = UrlBuilder.buildStreamUrl(String.format("%s/stream", this.baseUrl), streams);
        Request request = RequestBuilder.buildWebsocketRequest(url);
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public void closeConnection(int connectionId) {
        if (this.connections.containsKey(connectionId)) {
            this.connections.get(connectionId).close();
            logger.info("Closing Connection ID {}", (Object)connectionId);
            this.connections.remove(connectionId);
        } else {
            logger.info("Connection ID {} does not exist!", (Object)connectionId);
        }
    }

    @Override
    public void closeAllConnections() {
        if (!this.connections.isEmpty()) {
            logger.info("Closing {} connections(s)", (Object)this.connections.size());
            Iterator<Map.Entry<Integer, WebSocketConnection>> iter = this.connections.entrySet().iterator();
            while (iter.hasNext()) {
                WebSocketConnection connection = iter.next().getValue();
                connection.close();
                iter.remove();
            }
        }
        if (this.connections.isEmpty()) {
            HttpClientSingleton.getHttpClient().dispatcher().executorService().shutdown();
            logger.info("All connections are closed!");
        }
    }

    public int createConnection(WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback, Request request) {
        WebSocketConnection connection = new WebSocketConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
        connection.connect();
        int connectionId = connection.getConnectionId();
        this.connections.put(connectionId, connection);
        return connectionId;
    }
}

