/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.futures.client.impl.cm_futures;

import com.binance.connector.futures.client.enums.HttpMethod;
import com.binance.connector.futures.client.impl.futures.Account;
import com.binance.connector.futures.client.utils.ParameterChecker;
import com.binance.connector.futures.client.utils.ProxyAuth;
import java.util.LinkedHashMap;

public class CMAccount
extends Account {
    private final String ORDER = "/v1/order";
    private final String ORDER_AMENDMENT = "/v1/orderAmendment";
    private final String BALANCE = "/v1/balance";
    private final String ACCOUNT_INFORMATION = "/v1/account";
    private final String POSITION_RISK_V1 = "/v1/positionRisk";
    private final String LEVERAGE_BRACKET_PAIR = "/v2/leverageBracket";

    public CMAccount(String productUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        super(productUrl, apiKey, secretKey, showLimitUsage, proxy);
    }

    public String modifyOrder(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        return this.getRequestHandler().sendSignedRequest(this.getProductUrl(), "/v1/order", parameters, HttpMethod.PUT, this.getShowLimitUsage());
    }

    public String orderModifyHistory(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.getRequestHandler().sendSignedRequest(this.getProductUrl(), "/v1/orderAmendment", parameters, HttpMethod.GET, this.getShowLimitUsage());
    }

    @Override
    public String currentAllOpenOrders(LinkedHashMap<String, Object> parameters) {
        return super.currentAllOpenOrders(parameters);
    }

    @Override
    public String allOrders(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkOrParameters(parameters, "symbol", "pair");
        return super.allOrders(parameters);
    }

    public String futuresAccountBalance(LinkedHashMap<String, Object> parameters) {
        return this.getRequestHandler().sendSignedRequest(this.getProductUrl(), "/v1/balance", parameters, HttpMethod.GET, this.getShowLimitUsage());
    }

    public String accountInformation(LinkedHashMap<String, Object> parameters) {
        return this.getRequestHandler().sendSignedRequest(this.getProductUrl(), "/v1/account", parameters, HttpMethod.GET, this.getShowLimitUsage());
    }

    public String positionInformation(LinkedHashMap<String, Object> parameters) {
        return this.getRequestHandler().sendSignedRequest(this.getProductUrl(), "/v1/positionRisk", parameters, HttpMethod.GET, this.getShowLimitUsage());
    }

    @Override
    public String accountTradeList(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkOrParameters(parameters, "symbol", "pair");
        return super.accountTradeList(parameters);
    }

    @Override
    public String getLeverageBracket(LinkedHashMap<String, Object> parameters) {
        return super.getLeverageBracket(parameters);
    }

    public String getLeverageBracketForPair(LinkedHashMap<String, Object> parameters) {
        return this.getRequestHandler().sendSignedRequest(this.getProductUrl(), "/v2/leverageBracket", parameters, HttpMethod.GET, this.getShowLimitUsage());
    }
}

