/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.futures.client.impl.futures;

import com.binance.connector.futures.client.enums.HttpMethod;
import com.binance.connector.futures.client.utils.ParameterChecker;
import com.binance.connector.futures.client.utils.ProxyAuth;
import com.binance.connector.futures.client.utils.RequestHandler;
import java.util.LinkedHashMap;

public abstract class Account {
    private String productUrl;
    private RequestHandler requestHandler;
    private boolean showLimitUsage;
    private final String OPEN_ORDERS = "/v1/openOrders";
    private final String ALL_ORDERS = "/v1/allOrders";
    private final String USER_TRADES = "/v1/userTrades";
    private final String LEVERAGE_BRACKET = "/v1/leverageBracket";
    private final String POSITION_SIDE_DUAL = "/v1/positionSide/dual";
    private final String ORDER = "/v1/order";
    private final String BATCH_ORDERS = "/v1/batchOrders";
    private final String ALL_OPEN_ORDERS = "/v1/allOpenOrders";
    private final String CANCEL_ALL = "/v1/countdownCancelAll";
    private final String OPEN_ORDER = "/v1/openOrder";
    private final String LEVERAGE = "/v1/leverage";
    private final String MARGIN_TYPE = "/v1/marginType";
    private final String POSITION_MARGIN = "/v1/positionMargin";
    private final String POSITION_MARGIN_HISTORY = "/v1/positionMargin/history";
    private final String INCOME = "/v1/income";
    private final String ADL_QUANTILE = "/v1/adlQuantile";
    private final String FORCE_ORDERS = "/v1/forceOrders";
    private final String COMMISSION_RATE = "/v1/commissionRate";

    public Account(String productUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.productUrl = productUrl;
        this.requestHandler = new RequestHandler(apiKey, secretKey, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String getProductUrl() {
        return this.productUrl;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public boolean getShowLimitUsage() {
        return this.showLimitUsage;
    }

    public void setProductUrl(String productUrl) {
        this.productUrl = productUrl;
    }

    public void setRequestHandler(String apiKey, String secretKey, ProxyAuth proxy) {
        this.requestHandler = new RequestHandler(apiKey, secretKey, proxy);
    }

    public void setShowLimitUsage(boolean showLimitUsage) {
        this.showLimitUsage = showLimitUsage;
    }

    public String currentAllOpenOrders(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/openOrders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String allOrders(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/allOrders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String accountTradeList(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/userTrades", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getLeverageBracket(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/leverageBracket", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String changePositionModeTrade(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "dualSidePosition", String.class);
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/positionSide/dual", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String getCurrentPositionMode(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/positionSide/dual", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String newOrder(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/order", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String placeMultipleOrders(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkRequiredParameter(parameters, "batchOrders");
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/batchOrders", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String queryOrder(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkOrParameters(parameters, "orderId", "origClientOrderId");
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/order", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String cancelOrder(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkOrParameters(parameters, "orderId", "origClientOrderId");
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/order", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String cancelAllOpenOrders(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/allOpenOrders", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String cancelMultipleOrders(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/batchOrders", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String autoCancelOpen(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "countdownTime", Integer.class);
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/countdownCancelAll", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String queryCurrentOpenOrder(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkOrParameters(parameters, "orderId", "origClientOrderId");
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/openOrder", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String changeInitialLeverage(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "leverage", Integer.class);
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/leverage", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String changeMarginType(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "marginType", String.class);
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/marginType", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String modifyIsolatedPositionMargin(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        ParameterChecker.checkParameter(parameters, "type", Integer.class);
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/positionMargin", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String getPositionMarginChangeHistory(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/positionMargin/history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getIncomeHistory(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/income", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getAdlQuantile(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/adlQuantile", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getForceOrders(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/forceOrders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getCommissionRate(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.productUrl, "/v1/commissionRate", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

