/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.futures.client.impl.futures;

import com.binance.connector.futures.client.enums.HttpMethod;
import com.binance.connector.futures.client.utils.ParameterChecker;
import com.binance.connector.futures.client.utils.ProxyAuth;
import com.binance.connector.futures.client.utils.RequestHandler;
import java.util.LinkedHashMap;

public abstract class Market {
    private String baseUrl;
    private String productUrl;
    private RequestHandler requestHandler;
    private boolean showLimitUsage;
    private final String MARK_PRICE = "/v1/premiumIndex";
    private final String TICKER_24H = "/v1/ticker/24hr";
    private final String TICKER_SYMBOL = "/v1/ticker/price";
    private final String BOOK_TICKER = "/v1/ticker/bookTicker";
    private final String OPEN_INTEREST_STATS = "/futures/data/openInterestHist";
    private final String TOP_TRADER_LONG_SHORT_RATIO_POSITIONS = "/futures/data/topLongShortPositionRatio";
    private final String TOP_TRADER_LONG_SHORT_RATIO_ACCOUNTS = "/futures/data/topLongShortAccountRatio";
    private final String GLOBAL_LONG_SHORT = "/futures/data/globalLongShortAccountRatio";
    private final String PING = "/v1/ping";
    private final String TIME = "/v1/time";
    private final String EXCHANGE_INFO = "/v1/exchangeInfo";
    private final String DEPTH = "/v1/depth";
    private final String TRADES = "/v1/trades";
    private final String HISTORICAL_TRADES = "/v1/historicalTrades";
    private final String AGG_TRADES = "/v1/aggTrades";
    private final String KLINES = "/v1/klines";
    private final String CONTINUOUSKLINES = "/v1/continuousKlines";
    private final String INDEXPRICEKLINES = "/v1/indexPriceKlines";
    private final String MARKPRICEKLINES = "/v1/markPriceKlines";
    private final String FUNDING_RATE = "/v1/fundingRate";
    private final String OPEN_INTEREST = "/v1/openInterest";

    public Market(String productUrl, String baseUrl, String apiKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.productUrl = productUrl;
        this.requestHandler = new RequestHandler(apiKey, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getProductUrl() {
        return this.productUrl;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public boolean getShowLimitUsage() {
        return this.showLimitUsage;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setProductUrl(String productUrl) {
        this.productUrl = productUrl;
    }

    public void setRequestHandler(String apiKey, String secretKey, ProxyAuth proxy) {
        new RequestHandler(apiKey, secretKey, proxy);
    }

    public void setShowLimitUsage(boolean showLimitUsage) {
        this.showLimitUsage = showLimitUsage;
    }

    public String markPrice(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/premiumIndex", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String ticker24H(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/ticker/24hr", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String tickerSymbol(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/ticker/price", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String bookTicker(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/ticker/bookTicker", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String openInterestStatistics(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/futures/data/openInterestHist", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String topTraderLongShortPos(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/futures/data/topLongShortPositionRatio", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String topTraderLongShortAccs(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/futures/data/topLongShortAccountRatio", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String longShortRatio(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/futures/data/globalLongShortAccountRatio", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String ping() {
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/ping", null, HttpMethod.GET, this.showLimitUsage);
    }

    public String time() {
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/time", null, HttpMethod.GET, this.showLimitUsage);
    }

    public String exchangeInfo() {
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/exchangeInfo", null, HttpMethod.GET, this.showLimitUsage);
    }

    public String depth(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/depth", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String trades(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/trades", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String historicalTrades(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendWithApiKeyRequest(this.productUrl, "/v1/historicalTrades", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String aggTrades(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/aggTrades", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String klines(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "interval", String.class);
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/klines", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String continuousKlines(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "pair", String.class);
        ParameterChecker.checkParameter(parameters, "contractType", String.class);
        ParameterChecker.checkParameter(parameters, "interval", String.class);
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/continuousKlines", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String indexPriceKlines(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "pair", String.class);
        ParameterChecker.checkParameter(parameters, "interval", String.class);
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/indexPriceKlines", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String markPriceKlines(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "interval", String.class);
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/markPriceKlines", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String fundingRate(LinkedHashMap<String, Object> parameters) {
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/fundingRate", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String openInterest(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendPublicRequest(this.productUrl, "/v1/openInterest", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

