/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.futures.client.impl.futures;

import com.binance.connector.futures.client.enums.HttpMethod;
import com.binance.connector.futures.client.utils.ProxyAuth;
import com.binance.connector.futures.client.utils.RequestHandler;

public abstract class UserData {
    private String productUrl;
    private RequestHandler requestHandler;
    private boolean showLimitUsage;
    private final String LISTEN_KEY = "/v1/listenKey";

    public UserData(String productUrl, String apiKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.productUrl = productUrl;
        this.requestHandler = new RequestHandler(apiKey, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String getProductUrl() {
        return this.productUrl;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public boolean getShowLimitUsage() {
        return this.showLimitUsage;
    }

    public void setProductUrl(String productUrl) {
        this.productUrl = productUrl;
    }

    public void setRequestHandler(String apiKey, ProxyAuth proxy) {
        this.requestHandler = new RequestHandler(apiKey, proxy);
    }

    public void setShowLimitUsage(boolean showLimitUsage) {
        this.showLimitUsage = showLimitUsage;
    }

    public String createListenKey() {
        return this.requestHandler.sendWithApiKeyRequest(this.productUrl, "/v1/listenKey", null, HttpMethod.POST, this.showLimitUsage);
    }

    public String extendListenKey() {
        return this.requestHandler.sendWithApiKeyRequest(this.productUrl, "/v1/listenKey", null, HttpMethod.PUT, this.showLimitUsage);
    }

    public String closeListenKey() {
        return this.requestHandler.sendWithApiKeyRequest(this.productUrl, "/v1/listenKey", null, HttpMethod.DELETE, this.showLimitUsage);
    }
}

