/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.futures.client.impl.um_futures;

import com.binance.connector.futures.client.enums.HttpMethod;
import com.binance.connector.futures.client.impl.futures.Account;
import com.binance.connector.futures.client.utils.ParameterChecker;
import com.binance.connector.futures.client.utils.ProxyAuth;
import java.util.LinkedHashMap;

public class UMAccount
extends Account {
    private final String MULTI_ASSETS_MARGIN = "/v1/multiAssetsMargin";
    private final String BALANCE = "/v2/balance";
    private final String ACCOUNT_INFORMATION = "/v2/account";
    private final String POSITION_RISK = "/v2/positionRisk";
    private final String API_TRADING_STATUS = "/v1/apiTradingStatus";
    private final String INCOME_ASYN = "/v1/income/asyn";
    private final String INCOME_ASYN_ID = "/v1/income/asyn/id";

    public UMAccount(String productUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        super(productUrl, apiKey, secretKey, showLimitUsage, proxy);
    }

    public String changeMultiAssetsMode(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "dualSidePosition", String.class);
        return this.getRequestHandler().sendSignedRequest(this.getProductUrl(), "/v1/multiAssetsMargin", parameters, HttpMethod.POST, this.getShowLimitUsage());
    }

    public String getCurrentMultiAssetMode(LinkedHashMap<String, Object> parameters) {
        return this.getRequestHandler().sendSignedRequest(this.getProductUrl(), "/v1/multiAssetsMargin", parameters, HttpMethod.GET, this.getShowLimitUsage());
    }

    @Override
    public String currentAllOpenOrders(LinkedHashMap<String, Object> parameters) {
        return super.currentAllOpenOrders(parameters);
    }

    @Override
    public String allOrders(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return super.allOrders(parameters);
    }

    public String futuresAccountBalance(LinkedHashMap<String, Object> parameters) {
        return this.getRequestHandler().sendSignedRequest(this.getProductUrl(), "/v2/balance", parameters, HttpMethod.GET, this.getShowLimitUsage());
    }

    public String accountInformation(LinkedHashMap<String, Object> parameters) {
        return this.getRequestHandler().sendSignedRequest(this.getProductUrl(), "/v2/account", parameters, HttpMethod.GET, this.getShowLimitUsage());
    }

    public String positionInformation(LinkedHashMap<String, Object> parameters) {
        return this.getRequestHandler().sendSignedRequest(this.getProductUrl(), "/v2/positionRisk", parameters, HttpMethod.GET, this.getShowLimitUsage());
    }

    @Override
    public String accountTradeList(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return super.accountTradeList(parameters);
    }

    @Override
    public String getLeverageBracket(LinkedHashMap<String, Object> parameters) {
        return super.getLeverageBracket(parameters);
    }

    public String getTradingRulesIndicators(LinkedHashMap<String, Object> parameters) {
        return this.getRequestHandler().sendSignedRequest(this.getProductUrl(), "/v1/apiTradingStatus", parameters, HttpMethod.GET, this.getShowLimitUsage());
    }

    public String futuresDownloadId(LinkedHashMap<String, Object> parameters) {
        return this.getRequestHandler().sendSignedRequest(this.getProductUrl(), "/v1/income/asyn", parameters, HttpMethod.GET, this.getShowLimitUsage());
    }

    public String futuresDownloadLink(LinkedHashMap<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "downloadId", String.class);
        return this.getRequestHandler().sendSignedRequest(this.getProductUrl(), "/v1/income/asyn/id", parameters, HttpMethod.GET, this.getShowLimitUsage());
    }
}

