/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.futures.client.utils;

import com.binance.connector.futures.client.utils.ProxyAuth;
import java.net.Proxy;
import okhttp3.OkHttpClient;

public final class HttpClientSingleton {
    private static OkHttpClient httpClient = null;

    private HttpClientSingleton() {
    }

    public static OkHttpClient getHttpClient() {
        if (httpClient == null) {
            HttpClientSingleton.createHttpClient(null);
        }
        return httpClient;
    }

    public static OkHttpClient getHttpClient(ProxyAuth proxy) {
        if (httpClient == null) {
            HttpClientSingleton.createHttpClient(proxy);
        } else {
            HttpClientSingleton.verifyHttpClient(proxy);
        }
        return httpClient;
    }

    private static void createHttpClient(ProxyAuth proxy) {
        httpClient = proxy == null ? new OkHttpClient() : (proxy.getAuth() == null ? new OkHttpClient.Builder().proxy(proxy.getProxy()).build() : new OkHttpClient.Builder().proxy(proxy.getProxy()).proxyAuthenticator(proxy.getAuth()).build());
    }

    private static void verifyHttpClient(ProxyAuth proxy) {
        Proxy prevProxy = httpClient.proxy();
        if (proxy != null && !proxy.getProxy().equals(prevProxy) || proxy == null && prevProxy != null) {
            HttpClientSingleton.createHttpClient(proxy);
        }
    }
}

