/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.futures.client.utils;

import com.binance.connector.futures.client.exceptions.BinanceClientException;
import com.binance.connector.futures.client.exceptions.BinanceConnectorException;
import com.binance.connector.futures.client.exceptions.BinanceServerException;
import com.binance.connector.futures.client.utils.HttpClientSingleton;
import com.binance.connector.futures.client.utils.JSONParser;
import com.binance.connector.futures.client.utils.ProxyAuth;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResponseHandler {
    private static OkHttpClient client;
    private static final int HTTP_STATUS_CODE_400 = 400;
    private static final int HTTP_STATUS_CODE_499 = 499;
    private static final int HTTP_STATUS_CODE_500 = 500;

    private ResponseHandler() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String handleResponse(Request request, boolean showLimitUsage, ProxyAuth proxy) {
        client = HttpClientSingleton.getHttpClient(proxy);
        try (Response response = client.newCall(request).execute();){
            if (null == response) {
                throw new BinanceServerException("[ResponseHandler] No response from server");
            }
            String responseAsString = ResponseHandler.getResponseBodyAsString(response.body());
            if (response.code() >= 400 && response.code() <= 499) {
                throw ResponseHandler.handleErrorResponse(responseAsString, response.code());
            }
            if (response.code() >= 500) {
                throw new BinanceServerException(responseAsString, response.code());
            }
            if (showLimitUsage) {
                String string = ResponseHandler.getlimitUsage(response, responseAsString);
                return string;
            }
            String string = responseAsString;
            return string;
        }
        catch (IOException | IllegalStateException e) {
            String exceptionMsg = "OKHTTP Error: ";
            if (proxy == null) throw new BinanceConnectorException("[ResponseHandler] " + exceptionMsg + e.getMessage());
            if (e.getClass().equals(ConnectException.class)) {
                exceptionMsg = "Proxy Connection Error: ";
                throw new BinanceConnectorException("[ResponseHandler] " + exceptionMsg + e.getMessage());
            }
            if (!e.getClass().equals(UnknownHostException.class)) throw new BinanceConnectorException("[ResponseHandler] " + exceptionMsg + e.getMessage());
            exceptionMsg = "Proxy Unknown Host Error: ";
            throw new BinanceConnectorException("[ResponseHandler] " + exceptionMsg + e.getMessage());
        }
    }

    private static String getlimitUsage(Response response, String resposeBodyAsString) {
        JSONObject json = new JSONObject();
        json.put("x-mbx-used-weight", (Object)response.header("x-mbx-used-weight"));
        json.put("x-mbx-used-weight-1m", (Object)response.header("x-mbx-used-weight-1m"));
        json.put("data", (Object)resposeBodyAsString);
        return json.toString();
    }

    private static BinanceClientException handleErrorResponse(String responseBody, int responseCode) {
        try {
            String errorMsg = JSONParser.getJSONStringValue(responseBody, "msg");
            int errorCode = JSONParser.getJSONIntValue(responseBody, "code");
            return new BinanceClientException(responseBody, errorMsg, responseCode, errorCode);
        }
        catch (JSONException e) {
            throw new BinanceClientException(responseBody, responseCode);
        }
    }

    private static String getResponseBodyAsString(ResponseBody body) throws IOException {
        if (null != body) {
            return body.string();
        }
        return "";
    }
}

