/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.futures.client.utils;

import com.binance.connector.futures.client.utils.HttpClientSingleton;
import com.binance.connector.futures.client.utils.WebSocketCallback;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnection
extends WebSocketListener {
    private static final AtomicInteger connectionCounter = new AtomicInteger(0);
    private static final int NORMAL_CLOSURE_STATUS = 1000;
    private static final OkHttpClient client = HttpClientSingleton.getHttpClient();
    private static final Logger logger = LoggerFactory.getLogger(WebSocketConnection.class);
    private final WebSocketCallback onOpenCallback;
    private final WebSocketCallback onMessageCallback;
    private final WebSocketCallback onClosingCallback;
    private final WebSocketCallback onFailureCallback;
    private final int connectionId;
    private final Request request;
    private final String streamName;
    private WebSocket webSocket;
    private final Object mutex;

    public WebSocketConnection(WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback, Request request) {
        this.onOpenCallback = onOpenCallback;
        this.onMessageCallback = onMessageCallback;
        this.onClosingCallback = onClosingCallback;
        this.onFailureCallback = onFailureCallback;
        this.connectionId = connectionCounter.incrementAndGet();
        this.request = request;
        this.streamName = request.url().host() + request.url().encodedPath();
        this.webSocket = null;
        this.mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.mutex;
        synchronized (object) {
            if (null == this.webSocket) {
                logger.info("[Connection {}] Connecting to {}", (Object)this.connectionId, (Object)this.streamName);
                this.webSocket = client.newWebSocket(this.request, (WebSocketListener)this);
            } else {
                logger.info("[Connection {}] is already connected to {}", (Object)this.connectionId, (Object)this.streamName);
            }
        }
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public void close() {
        if (null != this.webSocket) {
            logger.info("[Connection {}] Closing connection to {}", (Object)this.connectionId, (Object)this.streamName);
            this.webSocket.close(1000, null);
        }
    }

    public void onOpen(WebSocket ws, Response response) {
        logger.info("[Connection {}] Connected to Server", (Object)this.connectionId);
        this.onOpenCallback.onReceive(null);
    }

    public void onClosing(WebSocket ws, int code, String reason) {
        super.onClosing(ws, code, reason);
        this.onClosingCallback.onReceive(reason);
    }

    public void onMessage(WebSocket ws, String text) {
        this.onMessageCallback.onReceive(text);
    }

    public void onFailure(WebSocket ws, Throwable t, Response response) {
        logger.error("[Connection {}] Failure", (Object)this.connectionId, (Object)t);
        this.onFailureCallback.onReceive(null);
    }
}

