/*
 * Decompiled with CFR 0.152.
 */
package io.github.binark.querypredicate.builder;

import io.github.binark.querypredicate.annotation.EntityFieldName;
import io.github.binark.querypredicate.builder.PredicateBuilder;
import io.github.binark.querypredicate.filter.BaseFilter;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPredicateBuilder<F extends BaseFilter>
implements PredicateBuilder<F> {
    protected List<Predicate> buildBaseFilterPredicate(Path path, CriteriaBuilder criteriaBuilder, F filter, String fieldName) {
        CriteriaBuilder.In inExpressions;
        ArrayList<Predicate> filterPredicates = new ArrayList<Predicate>();
        if (((BaseFilter)filter).getIsEquals() != null) {
            filterPredicates.add(criteriaBuilder.equal((Expression)path.get(fieldName), ((BaseFilter)filter).getIsEquals()));
        }
        if (((BaseFilter)filter).getIsDifferent() != null) {
            filterPredicates.add(criteriaBuilder.notEqual((Expression)path.get(fieldName), ((BaseFilter)filter).getIsDifferent()));
        }
        if (Boolean.TRUE.equals(((BaseFilter)filter).getNull())) {
            filterPredicates.add(criteriaBuilder.isNull((Expression)path.get(fieldName)));
        }
        if (Boolean.FALSE.equals(((BaseFilter)filter).getNull())) {
            filterPredicates.add(criteriaBuilder.isNotNull((Expression)path.get(fieldName)));
        }
        if (((BaseFilter)filter).getIsIn() != null) {
            inExpressions = criteriaBuilder.in((Expression)path.get(fieldName));
            filterPredicates.add(inExpressions.in(((BaseFilter)filter).getIsIn().stream().toArray()));
        }
        if (((BaseFilter)filter).getIsNotIn() != null) {
            inExpressions = criteriaBuilder.in((Expression)path.get(fieldName));
            filterPredicates.add(inExpressions.in(((BaseFilter)filter).getIsNotIn().stream().toArray()).not());
        }
        return filterPredicates;
    }

    @Override
    public String getFieldNameFromAnnotation(Field field) {
        EntityFieldName entityFieldName = field.getAnnotation(EntityFieldName.class);
        if (entityFieldName == null) {
            throw new IllegalArgumentException("Missing " + EntityFieldName.class.getSimpleName() + " annotation on the field " + field.getName());
        }
        return entityFieldName.value();
    }
}

