/*
 * Decompiled with CFR 0.152.
 */
package io.github.binark.querypredicate.builder;

import io.github.binark.querypredicate.builder.AbstractPredicateBuilder;
import io.github.binark.querypredicate.filter.ComparableFilter;
import io.github.binark.querypredicate.filter.Range;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.List;

public abstract class ComparableFilterPredicateBuilder<F extends ComparableFilter>
extends AbstractPredicateBuilder<F> {
    public List<Predicate> buildComparablePredicate(Path path, CriteriaBuilder builder, F filter, String fieldName) {
        List<Predicate> predicates = this.buildBaseFilterPredicate(path, builder, filter, fieldName);
        if (((ComparableFilter)filter).getIsGreaterThan() != null) {
            predicates.add(builder.greaterThan((Expression)path.get(fieldName), ((ComparableFilter)filter).getIsGreaterThan()));
        }
        if (((ComparableFilter)filter).getIsGreaterThanOrEqualsTo() != null) {
            predicates.add(builder.greaterThanOrEqualTo((Expression)path.get(fieldName), ((ComparableFilter)filter).getIsGreaterThanOrEqualsTo()));
        }
        if (((ComparableFilter)filter).getIsLessThan() != null) {
            predicates.add(builder.lessThan((Expression)path.get(fieldName), ((ComparableFilter)filter).getIsLessThan()));
        }
        if (((ComparableFilter)filter).getIsLessThanOrEqualsTo() != null) {
            predicates.add(builder.lessThanOrEqualTo((Expression)path.get(fieldName), ((ComparableFilter)filter).getIsLessThanOrEqualsTo()));
        }
        if (((ComparableFilter)filter).getIsBetween() != null) {
            predicates.add(this.getBetweenPredicate(path, builder, ((ComparableFilter)filter).getIsBetween(), fieldName));
        }
        return predicates;
    }

    protected Predicate getBetweenPredicate(Path path, CriteriaBuilder builder, Range range, String fieldName) {
        Object start = range.getStart();
        Object end = range.getEnd();
        if (start == null || end == null) {
            throw new IllegalArgumentException("The between field must have both start and end value");
        }
        return builder.between((Expression)path.get(fieldName), start, end);
    }
}

