/*
 * Decompiled with CFR 0.152.
 */
package io.github.binark.querypredicate.builder;

import io.github.binark.querypredicate.builder.ComparableFilterPredicateBuilder;
import io.github.binark.querypredicate.filter.DateFilter;
import io.github.binark.querypredicate.filter.Range;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateFilterPredicateBuilder
extends ComparableFilterPredicateBuilder<DateFilter> {
    @Override
    public Predicate buildPredicate(Path path, CriteriaBuilder builder, DateFilter filter, String fieldName) {
        Predicate betweenPredicate;
        List<Predicate> predicates = super.buildComparablePredicate(path, builder, filter, fieldName);
        if (filter.getIsToday() != null) {
            Predicate betweenPredicate2 = this.getDateBetweenPredicate(path, builder, new Date(), fieldName);
            this.computeDateBetweenPredicate(filter.getIsToday(), predicates, betweenPredicate2);
        }
        if (filter.getIsTomorrow() != null) {
            Date tomorrow = new Date(new Date().getTime() + 86400000L);
            betweenPredicate = this.getDateBetweenPredicate(path, builder, tomorrow, fieldName);
            this.computeDateBetweenPredicate(filter.getIsTomorrow(), predicates, betweenPredicate);
        }
        if (filter.getIsYesterday() != null) {
            Date yesterday = new Date(new Date().getTime() - 86400000L);
            betweenPredicate = this.getDateBetweenPredicate(path, builder, yesterday, fieldName);
            this.computeDateBetweenPredicate(filter.getIsYesterday(), predicates, betweenPredicate);
        }
        return predicates.size() == 1 ? predicates.get(0) : builder.or(predicates.toArray(new Predicate[0]));
    }

    private void computeDateBetweenPredicate(Boolean filterRule, List<Predicate> basePredicates, Predicate betweenPredicate) {
        if (Boolean.TRUE.equals(filterRule)) {
            basePredicates.add(betweenPredicate);
        } else {
            basePredicates.add(betweenPredicate.not());
        }
    }

    private Predicate getDateBetweenPredicate(Path path, CriteriaBuilder builder, Date date, String fieldName) {
        Range<Date> range = new Range<Date>();
        range.setStart(this.atStartOfDay(date));
        range.setEnd(this.atEndOfDay(date));
        return this.getBetweenPredicate(path, builder, range, fieldName);
    }

    private Date atEndOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    private Date atStartOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

