/*
 * Decompiled with CFR 0.152.
 */
package io.github.binark.querypredicate.builder;

import io.github.binark.querypredicate.builder.ComparableFilterPredicateBuilder;
import io.github.binark.querypredicate.filter.LocalDateFilter;
import io.github.binark.querypredicate.filter.Range;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;

public class LocalDateFilterPredicateBuilder
extends ComparableFilterPredicateBuilder<LocalDateFilter> {
    @Override
    public Predicate buildPredicate(Path path, CriteriaBuilder builder, LocalDateFilter filter, String fieldName) {
        Predicate localDateBetweenPredicate;
        List<Predicate> predicates = super.buildComparablePredicate(path, builder, filter, fieldName);
        if (filter.getIsToday() != null) {
            localDateBetweenPredicate = this.getLocalDateBetweenPredicate(path, builder, LocalDate.now(), fieldName);
            this.computeDateBetweenPredicate(filter.getIsToday(), predicates, localDateBetweenPredicate);
        }
        if (filter.getIsTomorrow() != null) {
            localDateBetweenPredicate = this.getLocalDateBetweenPredicate(path, builder, LocalDate.now().plusDays(1L), fieldName);
            this.computeDateBetweenPredicate(filter.getIsTomorrow(), predicates, localDateBetweenPredicate);
        }
        if (filter.getIsYesterday() != null) {
            localDateBetweenPredicate = this.getLocalDateBetweenPredicate(path, builder, LocalDate.now().minusDays(1L), fieldName);
            this.computeDateBetweenPredicate(filter.getIsYesterday(), predicates, localDateBetweenPredicate);
        }
        return predicates.size() == 1 ? predicates.get(0) : builder.or(predicates.toArray(new Predicate[0]));
    }

    private void computeDateBetweenPredicate(Boolean filterRule, List<Predicate> basePredicates, Predicate betweenPredicate) {
        if (Boolean.TRUE.equals(filterRule)) {
            basePredicates.add(betweenPredicate);
        } else {
            basePredicates.add(betweenPredicate.not());
        }
    }

    private Predicate getLocalDateBetweenPredicate(Path path, CriteriaBuilder builder, LocalDate localDate, String fieldName) {
        Range<LocalDate> range = new Range<LocalDate>();
        range.setStart(this.atStartOfDay(localDate));
        range.setEnd(this.atEndOfDay(localDate));
        return this.getBetweenPredicate(path, builder, range, fieldName);
    }

    private LocalDate atStartOfDay(LocalDate localDate) {
        return localDate.atStartOfDay().toLocalDate();
    }

    private LocalDate atEndOfDay(LocalDate localDate) {
        return localDate.atTime(LocalTime.MAX).toLocalDate();
    }
}

