/*
 * Decompiled with CFR 0.152.
 */
package io.github.binark.querypredicate.builder;

import io.github.binark.querypredicate.builder.ComparableFilterPredicateBuilder;
import io.github.binark.querypredicate.filter.ComparableFilter;
import io.github.binark.querypredicate.filter.NumericFilter;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.List;

public abstract class NumericFilterPredicateBuilder<F extends NumericFilter>
extends ComparableFilterPredicateBuilder<F> {
    public List<Predicate> buildNumericPredicate(Path path, CriteriaBuilder builder, F filter, String fieldName) {
        List<Predicate> predicates = this.buildBaseFilterPredicate(path, builder, filter, fieldName);
        if (((ComparableFilter)filter).getIsGreaterThan() != null) {
            predicates.add(builder.gt((Expression)path.get(fieldName), (Number)((ComparableFilter)filter).getIsGreaterThan()));
        }
        if (((ComparableFilter)filter).getIsGreaterThanOrEqualsTo() != null) {
            predicates.add(builder.ge((Expression)path.get(fieldName), (Number)((ComparableFilter)filter).getIsGreaterThanOrEqualsTo()));
        }
        if (((ComparableFilter)filter).getIsLessThan() != null) {
            predicates.add(builder.lt((Expression)path.get(fieldName), (Number)((ComparableFilter)filter).getIsLessThan()));
        }
        if (((ComparableFilter)filter).getIsLessThanOrEqualsTo() != null) {
            predicates.add(builder.le((Expression)path.get(fieldName), (Number)((ComparableFilter)filter).getIsLessThanOrEqualsTo()));
        }
        if (((ComparableFilter)filter).getIsBetween() != null) {
            predicates.add(this.getBetweenPredicate(path, builder, ((ComparableFilter)filter).getIsBetween(), fieldName));
        }
        return predicates;
    }
}

