/*
 * Decompiled with CFR 0.152.
 */
package io.github.binark.querypredicate.builder;

import io.github.binark.querypredicate.builder.ComparableFilterPredicateBuilder;
import io.github.binark.querypredicate.filter.StringFilter;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.List;

public class StringFilterPredicateBuilder
extends ComparableFilterPredicateBuilder<StringFilter> {
    @Override
    public Predicate buildPredicate(Path path, CriteriaBuilder builder, StringFilter filter, String fieldName) {
        List<Predicate> predicates = this.buildComparablePredicate(path, builder, filter, fieldName);
        if (filter.getContains() != null) {
            predicates.add(builder.like((Expression)path.get(fieldName), "%" + filter.getContains() + "%"));
        }
        if (filter.getNotContains() != null) {
            predicates.add(builder.notLike((Expression)path.get(fieldName), "%" + filter.getNotContains() + "%"));
        }
        if (filter.getStartWith() != null) {
            predicates.add(builder.like((Expression)path.get(fieldName), filter.getStartWith() + "%"));
        }
        if (filter.getEndWith() != null) {
            predicates.add(builder.like((Expression)path.get(fieldName), "%" + filter.getEndWith()));
        }
        if (filter.getContainsIgnoreCase() != null) {
            predicates.add(builder.like(builder.upper((Expression)path.get(fieldName)), "%" + filter.getContainsIgnoreCase().toUpperCase() + "%"));
        }
        if (filter.getNotContainsIgnoreCase() != null) {
            predicates.add(builder.notLike(builder.upper((Expression)path.get(fieldName)), "%" + filter.getNotContainsIgnoreCase().toUpperCase() + "%"));
        }
        if (filter.getStartWithIgnoreCase() != null) {
            predicates.add(builder.like(builder.upper((Expression)path.get(fieldName)), filter.getStartWithIgnoreCase().toUpperCase() + "%"));
        }
        if (filter.getEndWithIgnoreCase() != null) {
            predicates.add(builder.like(builder.upper((Expression)path.get(fieldName)), "%" + filter.getEndWithIgnoreCase().toUpperCase()));
        }
        return predicates.size() == 1 ? predicates.get(0) : builder.or(predicates.toArray(new Predicate[0]));
    }
}

