/*
 * Decompiled with CFR 0.152.
 */
package io.github.binark.querypredicate.descriptor.converter;

import io.github.binark.querypredicate.annotation.EntityFieldName;
import io.github.binark.querypredicate.builder.PredicateBuilder;
import io.github.binark.querypredicate.descriptor.QueryDescriptor;
import io.github.binark.querypredicate.filter.Filter;
import io.github.binark.querypredicate.management.BasePredicateBuilderResolver;
import io.github.binark.querypredicate.management.PredicateBuilderResolver;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class QueryDescriptorConverter<Q extends QueryDescriptor> {
    Logger logger = Logger.getLogger(QueryDescriptorConverter.class.getSimpleName());
    private final PredicateBuilderResolver predicateBuilderResolver;

    public QueryDescriptorConverter() {
        this.predicateBuilderResolver = new BasePredicateBuilderResolver();
    }

    public QueryDescriptorConverter(PredicateBuilderResolver predicateBuilderResolver) {
        this.predicateBuilderResolver = predicateBuilderResolver;
    }

    public List<Predicate> convert(Root root, CriteriaBuilder builder, Q queryDescriptor) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        List<Field> queryDescriptorFields = this.extractQueryDescriptorFields(queryDescriptor.getClass());
        List filterFields = queryDescriptorFields.stream().filter(field -> Filter.class.isAssignableFrom(field.getType())).collect(Collectors.toList());
        for (Field field2 : filterFields) {
            Predicate predicate = this.getPredicateFromField(field2, (Path)root, builder, (QueryDescriptor)queryDescriptor);
            if (predicate == null) continue;
            predicates.add(predicate);
        }
        List subQueryDescriptorFields = queryDescriptorFields.stream().filter(field -> QueryDescriptor.class.isAssignableFrom(field.getType())).collect(Collectors.toList());
        for (Field field3 : subQueryDescriptorFields) {
            field3.setAccessible(true);
            try {
                QueryDescriptor subQueryDescriptorValue = (QueryDescriptor)field3.get(queryDescriptor);
                if (subQueryDescriptorValue == null) continue;
                predicates.addAll(this.joinDescriptor(root.join(field3.getName()), builder, subQueryDescriptorValue));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return predicates;
    }

    private List<Predicate> joinDescriptor(Join joinRoot, CriteriaBuilder builder, Q queryDescriptor) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        List<Field> queryDescriptorFields = this.extractQueryDescriptorFields(queryDescriptor.getClass());
        List filterFields = queryDescriptorFields.stream().filter(field -> Filter.class.isAssignableFrom(field.getType())).collect(Collectors.toList());
        for (Field field2 : filterFields) {
            Predicate predicate = this.getPredicateFromField(field2, (Path)joinRoot, builder, (QueryDescriptor)queryDescriptor);
            if (predicate == null) continue;
            predicates.add(predicate);
        }
        List subQueryDescriptorFields = queryDescriptorFields.stream().filter(field -> QueryDescriptor.class.isAssignableFrom(field.getType())).collect(Collectors.toList());
        for (Field field3 : subQueryDescriptorFields) {
            field3.setAccessible(true);
            try {
                QueryDescriptor subQueryDescriptorValue = (QueryDescriptor)field3.get(queryDescriptor);
                predicates.addAll(this.joinDescriptor(joinRoot.join(field3.getName()), builder, subQueryDescriptorValue));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return predicates;
    }

    private Predicate getPredicateFromField(Field field, Path path, CriteriaBuilder criteriaBuilder, QueryDescriptor queryDescriptor) {
        Predicate predicate = null;
        if (Filter.class.isAssignableFrom(field.getType())) {
            try {
                field.setAccessible(true);
                Object value = field.get(queryDescriptor);
                if (value != null) {
                    PredicateBuilder predicateBuilder = this.predicateBuilderResolver.resolverPredicateBuilder(value.getClass());
                    String fieldName = field.getName();
                    if (field.isAnnotationPresent(EntityFieldName.class)) {
                        fieldName = predicateBuilder.getFieldNameFromAnnotation(field);
                    }
                    predicate = predicateBuilder.buildPredicate(path, criteriaBuilder, (Filter)value, fieldName);
                }
            }
            catch (IllegalAccessException iae) {
                this.logger.log(Level.WARNING, "could not access field name: {}", field.getName());
                iae.printStackTrace();
            }
        }
        return predicate;
    }

    private List<Field> extractQueryDescriptorFields(Class queryDescriptorClass) {
        Field[] declaredFields = queryDescriptorClass.getDeclaredFields();
        List<Field> fields = Arrays.asList(declaredFields);
        Class superclass = queryDescriptorClass.getSuperclass();
        if (QueryDescriptor.class.isAssignableFrom(superclass)) {
            fields.addAll(this.extractQueryDescriptorFields(superclass));
        }
        return fields.stream().filter(field -> Filter.class.isAssignableFrom(field.getType()) || QueryDescriptor.class.isAssignableFrom(field.getType())).collect(Collectors.toList());
    }
}

