/*
 * Decompiled with CFR 0.152.
 */
package io.github.binark.querypredicate.management;

import io.github.binark.querypredicate.builder.BaseFilterPredicateBuilder;
import io.github.binark.querypredicate.builder.BooleanFilterPredicateBuilder;
import io.github.binark.querypredicate.builder.DateFilterPredicateBuilder;
import io.github.binark.querypredicate.builder.DoubleFilterPredicateBuilder;
import io.github.binark.querypredicate.builder.FloatFilterPredicateBuilder;
import io.github.binark.querypredicate.builder.IntegerFilterPredicateBuilder;
import io.github.binark.querypredicate.builder.LocalDateFilterPredicateBuilder;
import io.github.binark.querypredicate.builder.LongFilterPredicateBuilder;
import io.github.binark.querypredicate.builder.PredicateBuilder;
import io.github.binark.querypredicate.builder.StringFilterPredicateBuilder;
import io.github.binark.querypredicate.filter.BaseFilter;
import io.github.binark.querypredicate.filter.BooleanFilter;
import io.github.binark.querypredicate.filter.DateFilter;
import io.github.binark.querypredicate.filter.DoubleFilter;
import io.github.binark.querypredicate.filter.FloatFilter;
import io.github.binark.querypredicate.filter.IntegerFilter;
import io.github.binark.querypredicate.filter.LocalDateFilter;
import io.github.binark.querypredicate.filter.LongFilter;
import io.github.binark.querypredicate.filter.StringFilter;
import io.github.binark.querypredicate.management.PredicateBuilderStorage;
import java.util.HashMap;
import java.util.Map;

final class BasePredicateBuilderStorage
implements PredicateBuilderStorage {
    private final Map<String, PredicateBuilder> predicateBuilderMap = new HashMap<String, PredicateBuilder>();
    private static BasePredicateBuilderStorage INSTANCE;

    private BasePredicateBuilderStorage() {
        this.initializeStorage();
    }

    static BasePredicateBuilderStorage getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BasePredicateBuilderStorage();
        }
        return INSTANCE;
    }

    @Override
    public PredicateBuilder getPredicateBuilder(String key) {
        return this.predicateBuilderMap.get(key);
    }

    @Override
    public void addPredicateBuilder(String key, PredicateBuilder predicateBuilder) {
        this.predicateBuilderMap.put(key, predicateBuilder);
    }

    @Override
    public void initializeStorage() {
        this.predicateBuilderMap.put(BaseFilter.class.getSimpleName(), new BaseFilterPredicateBuilder());
        this.predicateBuilderMap.put(StringFilter.class.getSimpleName(), new StringFilterPredicateBuilder());
        this.predicateBuilderMap.put(BooleanFilter.class.getSimpleName(), new BooleanFilterPredicateBuilder());
        this.predicateBuilderMap.put(DateFilter.class.getSimpleName(), new DateFilterPredicateBuilder());
        this.predicateBuilderMap.put(LocalDateFilter.class.getSimpleName(), new LocalDateFilterPredicateBuilder());
        this.predicateBuilderMap.put(IntegerFilter.class.getSimpleName(), new IntegerFilterPredicateBuilder());
        this.predicateBuilderMap.put(LongFilter.class.getSimpleName(), new LongFilterPredicateBuilder());
        this.predicateBuilderMap.put(FloatFilter.class.getSimpleName(), new FloatFilterPredicateBuilder());
        this.predicateBuilderMap.put(DoubleFilter.class.getSimpleName(), new DoubleFilterPredicateBuilder());
    }
}

