/*
 * Decompiled with CFR 0.152.
 */
package io.github.binark.querypredicate.management;

import io.github.binark.querypredicate.annotation.FilterClass;
import io.github.binark.querypredicate.builder.PredicateBuilder;
import io.github.binark.querypredicate.filter.Filter;
import io.github.binark.querypredicate.management.BasePredicateBuilderStorage;
import io.github.binark.querypredicate.management.PredicateBuilderStorage;

public class PredicateBuilderRegistry {
    private final PredicateBuilderStorage storage;

    public PredicateBuilderRegistry() {
        this.storage = BasePredicateBuilderStorage.getInstance();
        this.storage.initializeStorage();
    }

    public PredicateBuilderRegistry(PredicateBuilderStorage storage) {
        this.storage = storage;
        storage.initializeStorage();
    }

    private void registerPredicateBuilder(String name, PredicateBuilder predicateBuilder) {
        this.storage.addPredicateBuilder(name, predicateBuilder);
    }

    public void registerPredicateBuilder(PredicateBuilder predicateBuilder) {
        FilterClass filterClass = predicateBuilder.getClass().getAnnotation(FilterClass.class);
        if (filterClass == null) {
            throw new IllegalArgumentException("You must put the " + FilterClass.class.getSimpleName() + " annotation on the " + predicateBuilder.getClass().getSimpleName() + " class");
        }
        this.registerPredicateBuilder(filterClass.value().getSimpleName(), predicateBuilder);
    }

    public void replacePredicateBuilder(Class<? extends Filter> filterClass, PredicateBuilder predicateBuilder) {
        this.registerPredicateBuilder(filterClass.getSimpleName(), predicateBuilder);
    }
}

