/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.Decoder;
import io.github.binaryfoo.bit.BitPackage;
import io.github.binaryfoo.bit.EmvBit;
import io.github.binaryfoo.decoders.DecodeSession;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lio/github/binaryfoo/decoders/ByteLabeller;", "Lio/github/binaryfoo/Decoder;", "()V", "decode", "", "Lio/github/binaryfoo/DecodedData;", "input", "", "startIndexInBytes", "", "session", "Lio/github/binaryfoo/decoders/DecodeSession;", "getMaxLength", "validate", "emv-bertlv"})
public final class ByteLabeller
implements Decoder {
    @Override
    @NotNull
    public List<DecodedData> decode(@NotNull String input, int startIndexInBytes, @NotNull DecodeSession session) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        ArrayList<DecodedData> decoded = new ArrayList<DecodedData>();
        for (EmvBit bit : BitPackage.fromHex(input)) {
            int byteIndex = startIndexInBytes + bit.getByteNumber() - 1;
            decoded.add(DecodedData.Companion.primitive(bit.toString(), "", byteIndex, byteIndex + 1));
        }
        return decoded;
    }

    @Override
    @Nullable
    public String validate(@Nullable String input) {
        if (input != null && input.length() % 2 != 0) {
            return "Must be an even number of characters";
        }
        return null;
    }

    @Override
    public int getMaxLength() {
        return Integer.MAX_VALUE;
    }
}

