/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.Decoder;
import io.github.binaryfoo.bit.BitPackage;
import io.github.binaryfoo.decoders.DecodeSession;
import io.github.binaryfoo.decoders.EmvBitStringDecoder;
import io.github.binaryfoo.decoders.bit.BitStringField;
import io.github.binaryfoo.decoders.bit.EmvBitStringParser;
import io.github.binaryfoo.res.ClasspathIO;
import io.github.binaryfoo.tlv.ISOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lio/github/binaryfoo/decoders/EmvBitStringDecoder;", "Lio/github/binaryfoo/Decoder;", "fileName", "", "showFieldHexInDecoding", "", "(Ljava/lang/String;Z)V", "bitMappings", "", "Lio/github/binaryfoo/decoders/bit/BitStringField;", "maxLength", "", "getShowFieldHexInDecoding", "()Z", "decode", "Lio/github/binaryfoo/DecodedData;", "input", "startIndexInBytes", "session", "Lio/github/binaryfoo/decoders/DecodeSession;", "findMaxLengthInBytes", "getMaxLength", "validate", "emv-bertlv"})
public class EmvBitStringDecoder
implements Decoder {
    private final List<BitStringField> bitMappings;
    private final int maxLength;
    private final boolean showFieldHexInDecoding;

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    /*
     * WARNING - void declaration
     */
    private final int findMaxLengthInBytes() {
        void destination$iv$iv;
        void $receiver$iv$iv;
        if (this.bitMappings.isEmpty()) {
            return 0;
        }
        findMaxLengthInBytes.1 max$ = findMaxLengthInBytes.1.INSTANCE;
        Iterable $receiver$iv = this.bitMappings;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            BitStringField bitStringField = (BitStringField)item$iv$iv;
            void var11_10 = destination$iv$iv;
            Integer n = it.getStartBytesOffset() + it.getLengthInBytes();
            var11_10.add(n);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p2;
            int n = ((Number)iterator$iv.next()).intValue();
            int p1 = ((Number)accumulator$iv).intValue();
            accumulator$iv = findMaxLengthInBytes.1.INSTANCE.invoke(p1, (int)p2);
        }
        return ((Number)accumulator$iv).intValue();
    }

    @Override
    @NotNull
    public List<DecodedData> decode(@NotNull String input, int startIndexInBytes, @NotNull DecodeSession session) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        ArrayList<DecodedData> decoded = new ArrayList<DecodedData>();
        Set bits = BitPackage.fromHex(input);
        for (BitStringField field : this.bitMappings) {
            String v = field.getValueIn(bits);
            if (v == null) continue;
            int fieldStartIndex = startIndexInBytes + field.getStartBytesOffset();
            decoded.add(DecodedData.Companion.primitive(field.getPositionIn(this.showFieldHexInDecoding ? bits : (Set)null), v, fieldStartIndex, fieldStartIndex + field.getLengthInBytes()));
        }
        return decoded;
    }

    @Override
    @Nullable
    public String validate(@Nullable String input) {
        if (input == null || input.length() != this.maxLength) {
            return "Value must be exactly " + this.maxLength + " characters";
        }
        if (!ISOUtil.isValidHexString(input)) {
            return "Value must contain only the characters 0-9 and A-F";
        }
        return null;
    }

    public final boolean getShowFieldHexInDecoding() {
        return this.showFieldHexInDecoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmvBitStringDecoder(@NotNull String fileName, boolean showFieldHexInDecoding) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        this.showFieldHexInDecoding = showFieldHexInDecoding;
        InputStream input = ClasspathIO.open(fileName);
        try {
            List list = IOUtils.readLines((InputStream)input);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"IOUtils.readLines(input)");
            this.bitMappings = EmvBitStringParser.parse(list);
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
        this.maxLength = this.findMaxLengthInBytes() * 2;
    }
}

