/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders.apdu;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.EmvTags;
import io.github.binaryfoo.decoders.DecodeSession;
import io.github.binaryfoo.decoders.PopulatedDOLDecoder;
import io.github.binaryfoo.decoders.apdu.APDUCommand;
import io.github.binaryfoo.decoders.apdu.CommandAPDUDecoder;
import io.github.binaryfoo.tlv.ISOUtil;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lio/github/binaryfoo/decoders/apdu/GenerateACAPDUDecoder;", "Lio/github/binaryfoo/decoders/apdu/CommandAPDUDecoder;", "()V", "decode", "Lio/github/binaryfoo/DecodedData;", "input", "", "startIndexInBytes", "", "session", "Lio/github/binaryfoo/decoders/DecodeSession;", "decodeCDOLElements", "", "populatedCdol", "findCDOL", "getCommand", "Lio/github/binaryfoo/decoders/apdu/APDUCommand;", "parseCryptogramType", "b", "", "Companion", "emv-bertlv"})
public final class GenerateACAPDUDecoder
implements CommandAPDUDecoder {
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @NotNull
    public APDUCommand getCommand() {
        return APDUCommand.GenerateAC;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DecodedData decode(@NotNull String input, int startIndexInBytes, @NotNull DecodeSession session) {
        void endIndex$iv;
        void startIndex$iv;
        void $receiver$iv;
        void endIndex$iv2;
        void startIndex$iv2;
        void $receiver$iv2;
        int endIndex$iv3;
        void startIndex$iv222;
        void $receiver$iv3;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        String string = input;
        int n = 8;
        int n2 = 10;
        void v0 = $receiver$iv3;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)v0).substring((int)startIndex$iv222, endIndex$iv3);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        int length = Integer.parseInt(string2, 16);
        String startIndex$iv222 = input;
        endIndex$iv3 = 4;
        int $i$f$substring = 6;
        void v2 = $receiver$iv2;
        if (v2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)v2).substring((int)startIndex$iv2, (int)endIndex$iv2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        byte cid = ISOUtil.hex2byte(string3)[0];
        String cryptogramType = this.parseCryptogramType(cid);
        boolean cda = (cid & 0x10) == 16;
        String $i$f$substring2 = input;
        int n3 = 10;
        int n4 = 10 + length * 2;
        void v4 = $receiver$iv;
        if (v4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = ((String)v4).substring((int)startIndex$iv, (int)endIndex$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String populatedCDOL = string4;
        List<DecodedData> decodedPopulatedCDOL = this.decodeCDOLElements(session, populatedCDOL, startIndexInBytes + 5);
        return DecodedData.Companion.constructed("C-APDU: Generate AC (" + cryptogramType + (cda ? "+CDA" : "") + ")", "CDOL " + populatedCDOL, startIndexInBytes, startIndexInBytes + 5 + length + 1, decodedPopulatedCDOL);
    }

    private final String parseCryptogramType(byte b) {
        if ((b & 0x40) == 64) {
            return "TC";
        }
        if ((b & 0x80) == 128) {
            return "ARQC";
        }
        return "AAC";
    }

    private final List<DecodedData> decodeCDOLElements(DecodeSession session, String populatedCdol, int startIndexInBytes) {
        String cdol = this.findCDOL(session);
        if (cdol != null) {
            try {
                return new PopulatedDOLDecoder().decode(cdol, populatedCdol, startIndexInBytes, session);
            }
            catch (Exception e) {
                GenerateACAPDUDecoder.Companion.getLOG().throwing(GenerateACAPDUDecoder.class.getSimpleName(), "decodeCDOLElements", e);
            }
        }
        return CollectionsKt.emptyList();
    }

    private final String findCDOL(DecodeSession session) {
        if (session.getFirstGenerateACCommand()) {
            session.setFirstGenerateACCommand(false);
            return (String)session.get((Object)EmvTags.CDOL_1);
        }
        return (String)session.get((Object)EmvTags.CDOL_2);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getLogger(GenerateACAPDUDecoder.class.getName());
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/github/binaryfoo/decoders/apdu/GenerateACAPDUDecoder$Companion;", "", "()V", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Ljava/util/logging/Logger;", "emv-bertlv"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

