/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.bit;

import io.github.binaryfoo.bit.EmvBit;
import io.github.binaryfoo.tlv.ISOUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004\u001a%\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\n\"\u00020\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u0010\u0010\f\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u001e\u0010\r\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\n\u0010\u0011\u001a\u00020\u0004*\u00020\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0018\u0010\u0012\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0006\u001a\u0018\u0010\u0014\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000e\u00a8\u0006\u0016"}, d2={"fromHex", "", "Lio/github/binaryfoo/bit/EmvBit;", "hex", "", "firstByteNumber", "", "labelFor", "setOf", "bits", "", "([Lio/github/binaryfoo/bit/EmvBit;)Ljava/util/Set;", "getByteCount", "matches", "", "other", "reduceToOnBits", "toConfigString", "toHexString", "fieldLengthInBytes", "toString", "includeValue", "emv-bertlv"})
@JvmName(name="BitPackage")
public final class BitPackage {
    @NotNull
    public static final Set<EmvBit> fromHex(@NotNull String hex) {
        Intrinsics.checkParameterIsNotNull((Object)hex, (String)"hex");
        return BitPackage.fromHex(hex, 1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<EmvBit> fromHex(@NotNull String hex, int firstByteNumber) {
        Intrinsics.checkParameterIsNotNull((Object)hex, (String)"hex");
        TreeSet<EmvBit> set = new TreeSet<EmvBit>();
        int n = 0;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)new IntRange(n, hex.length() - 1)), (int)2);
        int n2 = intProgression.getFirst();
        int n3 = intProgression.getLast();
        int n4 = intProgression.getStep();
        int n5 = n2;
        int n6 = n3;
        if (n4 >= 0 ? n5 <= n6 : n5 >= n6) {
            while (true) {
                void i;
                String string = hex;
                int n7 = i + 2;
                boolean bl = false;
                String string2 = string.substring((int)i, n7);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                int b = Integer.parseInt(string2, 16);
                void byteNumber = i / 2 + firstByteNumber;
                n7 = 7;
                bl = false;
                while (n7 >= 0) {
                    void j;
                    set.add(new EmvBit((int)byteNumber, (int)(j + true), (b >> j & 1) == 1));
                    --j;
                }
                if (i == n3) break;
                n2 = i + n4;
            }
        }
        return set;
    }

    @NotNull
    public static final String toHexString(@NotNull Set<EmvBit> $this$toHexString, int fieldLengthInBytes) {
        Intrinsics.checkParameterIsNotNull($this$toHexString, (String)"$this$toHexString");
        byte[] bytes = new byte[fieldLengthInBytes];
        for (EmvBit bit : $this$toHexString) {
            if (!bit.getSet()) continue;
            int byteIndex = bit.getByteNumber() - 1;
            byte b = bytes[byteIndex];
            bytes[byteIndex] = b = (byte)(b | 1 << bit.getBitNumber() - 1);
        }
        String string = ISOUtil.hexString(bytes);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ISOUtil.hexString(bytes)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<EmvBit> reduceToOnBits(@NotNull Set<EmvBit> $this$reduceToOnBits) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$reduceToOnBits, (String)"$this$reduceToOnBits");
        Iterable $this$filter$iv = $this$reduceToOnBits;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EmvBit it = (EmvBit)element$iv$iv;
            boolean bl = false;
            if (!it.getSet()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Collection collection = list;
        return new TreeSet(collection);
    }

    @NotNull
    public static final Set<EmvBit> setOf(EmvBit ... bits) {
        Intrinsics.checkParameterIsNotNull((Object)bits, (String)"bits");
        return SetsKt.sortedSetOf((Object[])Arrays.copyOf(bits, bits.length));
    }

    @NotNull
    public static final String toConfigString(@NotNull Set<EmvBit> $this$toConfigString) {
        Intrinsics.checkParameterIsNotNull($this$toConfigString, (String)"$this$toConfigString");
        StringBuilder b = new StringBuilder();
        for (EmvBit bit : $this$toConfigString) {
            if (b.length() > 0) {
                b.append(" & ");
            }
            b.append(BitPackage.toConfigString(bit));
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    @NotNull
    public static final String toConfigString(@NotNull EmvBit $this$toConfigString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toConfigString, (String)"$this$toConfigString");
        return "" + '(' + $this$toConfigString.getByteNumber() + ',' + $this$toConfigString.getBitNumber() + ")=" + $this$toConfigString.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public static final int getByteCount(@NotNull Set<EmvBit> $this$getByteCount) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$getByteCount, (String)"$this$getByteCount");
        Iterable $this$map$iv = $this$getByteCount;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        int $i$f$mapTo = 0;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EmvBit emvBit = (EmvBit)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.getByteNumber();
            collection.add(n);
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b;
            $i$f$mapTo = ((Number)iterator$iv.next()).intValue();
            int a = ((Number)accumulator$iv).intValue();
            boolean bl = false;
            accumulator$iv = a >= b ? a : b;
        }
        return ((Number)accumulator$iv).intValue();
    }

    public static final boolean matches(@NotNull Set<EmvBit> $this$matches, @NotNull Set<EmvBit> other) {
        Intrinsics.checkParameterIsNotNull($this$matches, (String)"$this$matches");
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        return CollectionsKt.intersect((Iterable)$this$matches, (Iterable)other).size() == $this$matches.size();
    }

    @NotNull
    public static final String toString(@NotNull Set<EmvBit> $this$toString, boolean includeValue) {
        Intrinsics.checkParameterIsNotNull($this$toString, (String)"$this$toString");
        StringBuilder b = new StringBuilder();
        for (EmvBit bit : $this$toString) {
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(bit.toString(false, includeValue));
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    @NotNull
    public static final String labelFor(@NotNull String hex) {
        Intrinsics.checkParameterIsNotNull((Object)hex, (String)"hex");
        return BitPackage.toString(BitPackage.fromHex(hex), false);
    }
}

