/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.crypto.RecoveredPublicKeyCertificate;
import io.github.binaryfoo.tlv.ISOUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"decodeICCPublicKeyCertificate", "Lio/github/binaryfoo/crypto/RecoveredPublicKeyCertificate;", "recovered", "", "byteLengthOfIssuerModulus", "", "startIndexInBytes", "emv-bertlv"})
public final class ICCPublicKeyDecoderKt {
    @NotNull
    public static final RecoveredPublicKeyCertificate decodeICCPublicKeyCertificate(@NotNull byte[] recovered, int byteLengthOfIssuerModulus, int startIndexInBytes) {
        Intrinsics.checkParameterIsNotNull((Object)recovered, (String)"recovered");
        int publicKeyLength = Integer.parseInt(ISOUtil.hexString(recovered, 19, 1), 16);
        String string = ISOUtil.hexString(recovered, 20, 1);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ISOUtil.hexString(recovered, 20, 1)");
        String exponentLength = string;
        int lengthOfLeftKeyPart = publicKeyLength > byteLengthOfIssuerModulus - 42 ? byteLengthOfIssuerModulus - 42 : publicKeyLength;
        String string2 = ISOUtil.hexString(recovered, 21, lengthOfLeftKeyPart);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ISOUtil.hexString(recove\u2026 21, lengthOfLeftKeyPart)");
        String leftKeyPart = string2;
        List children = CollectionsKt.listOf((Object[])new DecodedData[]{DecodedData.Companion.byteRange("Header", recovered, 0, 1, startIndexInBytes), DecodedData.Companion.byteRange("Format", recovered, 1, 1, startIndexInBytes), DecodedData.Companion.byteRange("PAN", recovered, 2, 10, startIndexInBytes), DecodedData.Companion.byteRange("Expiry Date (MMYY)", recovered, 12, 2, startIndexInBytes), DecodedData.Companion.byteRange("Serial number", recovered, 14, 3, startIndexInBytes), DecodedData.Companion.byteRange("Hash algorithm", recovered, 17, 1, startIndexInBytes), DecodedData.Companion.byteRange("Public key algorithm", recovered, 18, 1, startIndexInBytes), DecodedData.Companion.byteRange("Public key length", String.valueOf(publicKeyLength), 19, 1, startIndexInBytes), DecodedData.Companion.byteRange("Public key exponent length", exponentLength, 20, 1, startIndexInBytes), DecodedData.Companion.byteRange("Public key", leftKeyPart, 21, lengthOfLeftKeyPart, startIndexInBytes), DecodedData.Companion.byteRange("Hash", recovered, 21 + byteLengthOfIssuerModulus - 42, 20, startIndexInBytes), DecodedData.Companion.byteRange("Trailer", recovered, 21 + byteLengthOfIssuerModulus - 42 + 20, 1, startIndexInBytes)});
        return new RecoveredPublicKeyCertificate("ICC", children, exponentLength, leftKeyPart, null, 16, null);
    }
}

