/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.DecodedDataKt;
import io.github.binaryfoo.EmvTags;
import io.github.binaryfoo.crypto.CaPublicKey;
import io.github.binaryfoo.crypto.CaPublicKeyTable;
import io.github.binaryfoo.crypto.PublicKeyCertificate;
import io.github.binaryfoo.crypto.RecoveredPublicKeyCertificate;
import io.github.binaryfoo.decoders.DecodeSession;
import io.github.binaryfoo.decoders.IssuerPublicKeyDecoder;
import io.github.binaryfoo.decoders.annotator.SignedDataDecoder;
import io.github.binaryfoo.tlv.BerTlv;
import io.github.binaryfoo.tlv.Tag;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\r"}, d2={"Lio/github/binaryfoo/decoders/IssuerPublicKeyDecoder;", "Lio/github/binaryfoo/decoders/annotator/SignedDataDecoder;", "()V", "decodeSignedData", "", "session", "Lio/github/binaryfoo/decoders/DecodeSession;", "decoded", "", "Lio/github/binaryfoo/DecodedData;", "extractRid", "", "fileName", "emv-bertlv"})
public final class IssuerPublicKeyDecoder
implements SignedDataDecoder {
    @Override
    public void decodeSignedData(@NotNull DecodeSession session, @NotNull List<DecodedData> decoded) {
        CaPublicKey caPublicKey;
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(decoded, (String)"decoded");
        Tag tag = EmvTags.CA_PUBLIC_KEY_INDEX;
        Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"EmvTags.CA_PUBLIC_KEY_INDEX");
        String keyIndex = DecodedDataKt.findValueForTag(decoded, tag);
        Tag tag2 = EmvTags.ISSUER_PUBLIC_KEY_CERTIFICATE;
        Intrinsics.checkExpressionValueIsNotNull((Object)tag2, (String)"EmvTags.ISSUER_PUBLIC_KEY_CERTIFICATE");
        BerTlv encryptedCertificate = DecodedDataKt.findTlvForTag(decoded, tag2);
        Tag tag3 = EmvTags.DEDICATED_FILE_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)tag3, (String)"EmvTags.DEDICATED_FILE_NAME");
        String rid = this.extractRid(DecodedDataKt.findValueForTag(decoded, tag3));
        if (keyIndex != null && encryptedCertificate != null && rid != null && (caPublicKey = CaPublicKeyTable.Companion.getEntry(rid, keyIndex)) != null) {
            Tag tag4 = EmvTags.ISSUER_PUBLIC_KEY_CERTIFICATE;
            Intrinsics.checkExpressionValueIsNotNull((Object)tag4, (String)"EmvTags.ISSUER_PUBLIC_KEY_CERTIFICATE");
            for (DecodedData decodedCertificate : DecodedDataKt.findAllForTag(decoded, tag4)) {
                SignedDataDecoder.RecoveryResult result2 = this.recoverCertificate(encryptedCertificate, decodedCertificate, caPublicKey, (Function3<? super byte[], ? super Integer, ? super Integer, RecoveredPublicKeyCertificate>)((Function3)decodeSignedData.result.1.INSTANCE));
                if (result2.getCertificate() == null) continue;
                RecoveredPublicKeyCertificate recoveredPublicKeyCertificate = result2.getCertificate();
                Tag tag5 = EmvTags.ISSUER_PUBLIC_KEY_REMAINDER;
                Intrinsics.checkExpressionValueIsNotNull((Object)tag5, (String)"EmvTags.ISSUER_PUBLIC_KEY_REMAINDER");
                recoveredPublicKeyCertificate.setRightKeyPart(DecodedDataKt.findValueForTag(decoded, tag5));
                RecoveredPublicKeyCertificate recoveredPublicKeyCertificate2 = result2.getCertificate();
                Tag tag6 = EmvTags.ISSUER_PUBLIC_KEY_EXPONENT;
                Intrinsics.checkExpressionValueIsNotNull((Object)tag6, (String)"EmvTags.ISSUER_PUBLIC_KEY_EXPONENT");
                recoveredPublicKeyCertificate2.setExponent(DecodedDataKt.findValueForTag(decoded, tag6));
                session.setIssuerPublicKeyCertificate(result2.getCertificate());
            }
        }
    }

    @Nullable
    public final String extractRid(@Nullable String fileName) {
        String string;
        String string2 = fileName;
        if (string2 != null) {
            String string3 = string2;
            int n = 0;
            int n2 = 10;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public void recoverSignedData(@NotNull BerTlv signedData, @NotNull DecodedData decodedSignedData, @NotNull RecoveredPublicKeyCertificate certificateOfSigner, @NotNull Function2<? super byte[], ? super Integer, ? extends List<DecodedData>> decode) {
        Intrinsics.checkParameterIsNotNull((Object)signedData, (String)"signedData");
        Intrinsics.checkParameterIsNotNull((Object)decodedSignedData, (String)"decodedSignedData");
        Intrinsics.checkParameterIsNotNull((Object)certificateOfSigner, (String)"certificateOfSigner");
        Intrinsics.checkParameterIsNotNull(decode, (String)"decode");
        SignedDataDecoder.DefaultImpls.recoverSignedData(this, signedData, decodedSignedData, certificateOfSigner, decode);
    }

    @Override
    @NotNull
    public SignedDataDecoder.RecoveryResult recoverText(@NotNull String signedData, @NotNull RecoveredPublicKeyCertificate certificateOfSigner, int startIndexInBytes, @NotNull Function2<? super byte[], ? super Integer, ? extends List<DecodedData>> decode) {
        Intrinsics.checkParameterIsNotNull((Object)signedData, (String)"signedData");
        Intrinsics.checkParameterIsNotNull((Object)certificateOfSigner, (String)"certificateOfSigner");
        Intrinsics.checkParameterIsNotNull(decode, (String)"decode");
        return SignedDataDecoder.DefaultImpls.recoverText(this, signedData, certificateOfSigner, startIndexInBytes, decode);
    }

    @Override
    @NotNull
    public SignedDataDecoder.RecoveryResult recoverCertificate(@NotNull BerTlv encryptedCertificate, @NotNull DecodedData decodedCertificate, @NotNull PublicKeyCertificate certificateOfSigner, @NotNull Function3<? super byte[], ? super Integer, ? super Integer, RecoveredPublicKeyCertificate> decode) {
        Intrinsics.checkParameterIsNotNull((Object)encryptedCertificate, (String)"encryptedCertificate");
        Intrinsics.checkParameterIsNotNull((Object)decodedCertificate, (String)"decodedCertificate");
        Intrinsics.checkParameterIsNotNull((Object)certificateOfSigner, (String)"certificateOfSigner");
        Intrinsics.checkParameterIsNotNull(decode, (String)"decode");
        return SignedDataDecoder.DefaultImpls.recoverCertificate((SignedDataDecoder)this, encryptedCertificate, decodedCertificate, certificateOfSigner, decode);
    }
}

