/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.crypto.RecoveredPublicKeyCertificate;
import io.github.binaryfoo.tlv.ISOUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"decodeIssuerPublicKey", "Lio/github/binaryfoo/crypto/RecoveredPublicKeyCertificate;", "recovered", "", "byteLengthOfCAModulus", "", "startIndexInBytes", "emv-bertlv"})
public final class IssuerPublicKeyDecoderKt {
    @NotNull
    public static final RecoveredPublicKeyCertificate decodeIssuerPublicKey(@NotNull byte[] recovered, int byteLengthOfCAModulus, int startIndexInBytes) {
        Intrinsics.checkParameterIsNotNull((Object)recovered, (String)"recovered");
        int publicKeyLength = Integer.parseInt(ISOUtil.hexString(recovered, 13, 1), 16);
        String string = ISOUtil.hexString(recovered, 14, 1);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ISOUtil.hexString(recovered, 14, 1)");
        String exponentLength = string;
        int lengthOfLeftKeyPart = publicKeyLength > byteLengthOfCAModulus - 36 ? byteLengthOfCAModulus - 36 : publicKeyLength;
        String string2 = ISOUtil.hexString(recovered, 15, lengthOfLeftKeyPart);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ISOUtil.hexString(recove\u2026 15, lengthOfLeftKeyPart)");
        String leftKeyPart = string2;
        List b = CollectionsKt.listOf((Object[])new DecodedData[]{DecodedData.Companion.byteRange("Header", recovered, 0, 1, startIndexInBytes), DecodedData.Companion.byteRange("Format", recovered, 1, 1, startIndexInBytes), DecodedData.Companion.byteRange("Identifier (PAN prefix)", recovered, 2, 4, startIndexInBytes), DecodedData.Companion.byteRange("Expiry Date (MMYY)", recovered, 6, 2, startIndexInBytes), DecodedData.Companion.byteRange("Serial number", recovered, 8, 3, startIndexInBytes), DecodedData.Companion.byteRange("Hash algorithm", recovered, 11, 1, startIndexInBytes), DecodedData.Companion.byteRange("Public key algorithm", recovered, 12, 1, startIndexInBytes), DecodedData.Companion.byteRange("Public key length", String.valueOf(publicKeyLength), 13, 1, startIndexInBytes), DecodedData.Companion.byteRange("Public key exponent length", exponentLength, 14, 1, startIndexInBytes), DecodedData.Companion.byteRange("Public key", leftKeyPart, 15, lengthOfLeftKeyPart, startIndexInBytes), DecodedData.Companion.byteRange("Hash", recovered, 15 + byteLengthOfCAModulus - 36, 20, startIndexInBytes), DecodedData.Companion.byteRange("Trailer", recovered, 15 + byteLengthOfCAModulus - 36 + 20, 1, startIndexInBytes)});
        return new RecoveredPublicKeyCertificate("Issuer", b, exponentLength, leftKeyPart, null, 16, null);
    }
}

