/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.Decoder;
import io.github.binaryfoo.TagInfo;
import io.github.binaryfoo.TagMetaData;
import io.github.binaryfoo.decoders.DOLParser;
import io.github.binaryfoo.decoders.DecodeSession;
import io.github.binaryfoo.tlv.ISOUtil;
import io.github.binaryfoo.tlv.Tag;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u000e\u001a\u00020\tH\u0016J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lio/github/binaryfoo/decoders/PopulatedDOLDecoder;", "Lio/github/binaryfoo/Decoder;", "()V", "decode", "", "Lio/github/binaryfoo/DecodedData;", "input", "", "startIndexInBytes", "", "session", "Lio/github/binaryfoo/decoders/DecodeSession;", "pdol", "populatedPDOL", "getMaxLength", "validate", "emv-bertlv"})
public final class PopulatedDOLDecoder
implements Decoder {
    @Override
    @NotNull
    public List<DecodedData> decode(@NotNull String input, int startIndexInBytes, @NotNull DecodeSession session) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        List fields = StringsKt.split$default((CharSequence)input, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        String pdol = (String)fields.get(0);
        String populatedPDOL = (String)fields.get(1);
        return this.decode(pdol, populatedPDOL, pdol.length() / 2, session);
    }

    @NotNull
    public final List<DecodedData> decode(@NotNull String pdol, @NotNull String populatedPDOL, int startIndexInBytes, @NotNull DecodeSession session) {
        Intrinsics.checkParameterIsNotNull((Object)pdol, (String)"pdol");
        Intrinsics.checkParameterIsNotNull((Object)populatedPDOL, (String)"populatedPDOL");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        ArrayList<DecodedData> decoded = new ArrayList<DecodedData>();
        ByteBuffer values = ByteBuffer.wrap(ISOUtil.hex2byte(populatedPDOL));
        DOLParser dOLParser = new DOLParser();
        byte[] byArray = ISOUtil.hex2byte(pdol);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ISOUtil.hex2byte(pdol)");
        List<DOLParser.DOLElement> elements = dOLParser.parse(byArray);
        int offset = startIndexInBytes;
        for (DOLParser.DOLElement element : elements) {
            String valueAsHexString;
            byte[] value = new byte[element.getLength()];
            values.get(value);
            TagMetaData tagMetaData = session.getTagMetaData();
            Tag tag = element.getTag();
            TagMetaData tagMetaData2 = tagMetaData;
            if (tagMetaData2 == null) {
                Intrinsics.throwNpe();
            }
            TagInfo tagInfo = tagMetaData2.get(tag);
            Intrinsics.checkExpressionValueIsNotNull((Object)ISOUtil.hexString(value), (String)"ISOUtil.hexString(value)");
            List<DecodedData> children = tagInfo.getDecoder().decode(valueAsHexString, offset, session);
            DecodedData decodedData = DecodedData.Companion.withTag(tag, tagMetaData, tagInfo.decodePrimitiveTlvValue(valueAsHexString), offset, offset + value.length, children);
            decoded.add(decodedData);
            offset += value.length;
        }
        return decoded;
    }

    @Override
    @Nullable
    public String validate(@Nullable String input) {
        int fields;
        Object object = input;
        int n = object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null)) != null ? object.size() : (fields = 0);
        if (fields != 2) {
            return "Put : between the DOL and the populated list";
        }
        return null;
    }

    @Override
    public int getMaxLength() {
        return Integer.MAX_VALUE;
    }
}

