/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.tlv.ISOUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"decodeSignedDynamicData", "", "Lio/github/binaryfoo/DecodedData;", "recovered", "", "startIndexInBytes", "", "emv-bertlv"})
public final class SignedDynamicApplicationDataDecoderKt {
    @NotNull
    public static final List<DecodedData> decodeSignedDynamicData(@NotNull byte[] recovered, int startIndexInBytes) {
        DecodedData[] decodedDataArray;
        Intrinsics.checkParameterIsNotNull((Object)recovered, (String)"recovered");
        int dynamicDataLength = Integer.parseInt(ISOUtil.hexString(recovered, 3, 1), 16);
        int iccDynamicNumberLength = Integer.parseInt(ISOUtil.hexString(recovered, 4, 1), 16);
        String string = ISOUtil.hexString(recovered, 5 + iccDynamicNumberLength, 1);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ISOUtil.hexString(recove\u2026ccDynamicNumberLength, 1)");
        String cryptogramInformationData = string;
        SpreadBuilder spreadBuilder = new SpreadBuilder(9);
        spreadBuilder.add((Object)DecodedData.Companion.byteRange("Header", recovered, 0, 1, startIndexInBytes));
        spreadBuilder.add((Object)DecodedData.Companion.byteRange("Format", recovered, 1, 1, startIndexInBytes));
        spreadBuilder.add((Object)DecodedData.Companion.byteRange("Hash algorithm", recovered, 2, 1, startIndexInBytes));
        spreadBuilder.add((Object)DecodedData.Companion.byteRange("Dynamic data length", String.valueOf(dynamicDataLength), 3, 1, startIndexInBytes));
        spreadBuilder.add((Object)DecodedData.Companion.byteRange("ICC dynamic number length", String.valueOf(iccDynamicNumberLength), 4, 1, startIndexInBytes));
        spreadBuilder.add((Object)DecodedData.Companion.byteRange("ICC dynamic number", recovered, 5, iccDynamicNumberLength, startIndexInBytes));
        if (Intrinsics.areEqual((Object)cryptogramInformationData, (Object)"BB") ^ true) {
            DecodedData[] decodedDataArray2 = new DecodedData[3];
            decodedDataArray2[0] = DecodedData.Companion.byteRange("Cryptogram information data", cryptogramInformationData, 5 + iccDynamicNumberLength, 1, startIndexInBytes);
            decodedDataArray2[1] = DecodedData.Companion.byteRange("Cryptogram", recovered, 5 + iccDynamicNumberLength + 1, 8, startIndexInBytes);
            decodedDataArray = decodedDataArray2;
            decodedDataArray2[2] = DecodedData.Companion.byteRange("Transaction data hash code", recovered, 5 + iccDynamicNumberLength + 1 + 8, 20, startIndexInBytes);
        } else {
            decodedDataArray = new DecodedData[]{};
        }
        spreadBuilder.addSpread((Object)decodedDataArray);
        spreadBuilder.add((Object)DecodedData.Companion.byteRange("Hash", recovered, recovered.length - 21, 20, startIndexInBytes));
        spreadBuilder.add((Object)DecodedData.Companion.byteRange("Trailer", recovered, recovered.length - 1, 1, startIndexInBytes));
        return CollectionsKt.listOf((Object[])((DecodedData[])spreadBuilder.toArray((Object[])new DecodedData[spreadBuilder.size()])));
    }
}

