/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.DecodedDataKt;
import io.github.binaryfoo.EmvTags;
import io.github.binaryfoo.crypto.PublicKeyCertificate;
import io.github.binaryfoo.crypto.RecoveredPublicKeyCertificate;
import io.github.binaryfoo.decoders.DecodeSession;
import io.github.binaryfoo.decoders.SignedStaticApplicationDataDecoder;
import io.github.binaryfoo.decoders.annotator.SignedDataDecoder;
import io.github.binaryfoo.tlv.BerTlv;
import io.github.binaryfoo.tlv.Tag;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\n"}, d2={"Lio/github/binaryfoo/decoders/SignedStaticApplicationDataDecoder;", "Lio/github/binaryfoo/decoders/annotator/SignedDataDecoder;", "()V", "decodeSignedData", "", "session", "Lio/github/binaryfoo/decoders/DecodeSession;", "decoded", "", "Lio/github/binaryfoo/DecodedData;", "emv-bertlv"})
public final class SignedStaticApplicationDataDecoder
implements SignedDataDecoder {
    @Override
    public void decodeSignedData(@NotNull DecodeSession session, @NotNull List<DecodedData> decoded) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(decoded, (String)"decoded");
        RecoveredPublicKeyCertificate issuerPublicKeyCertificate = session.getIssuerPublicKeyCertificate();
        Tag tag = EmvTags.SIGNED_STATIC_APPLICATION_DATA;
        Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"EmvTags.SIGNED_STATIC_APPLICATION_DATA");
        BerTlv signedStaticData = DecodedDataKt.findTlvForTag(decoded, tag);
        if (signedStaticData != null && issuerPublicKeyCertificate != null) {
            Tag tag2 = EmvTags.SIGNED_STATIC_APPLICATION_DATA;
            Intrinsics.checkExpressionValueIsNotNull((Object)tag2, (String)"EmvTags.SIGNED_STATIC_APPLICATION_DATA");
            for (DecodedData decodedSSD : DecodedDataKt.findAllForTag(decoded, tag2)) {
                this.recoverSignedData(signedStaticData, decodedSSD, issuerPublicKeyCertificate, (Function2<? super byte[], ? super Integer, ? extends List<DecodedData>>)((Function2)decodeSignedData.1.INSTANCE));
            }
        }
    }

    @Override
    public void recoverSignedData(@NotNull BerTlv signedData, @NotNull DecodedData decodedSignedData, @NotNull RecoveredPublicKeyCertificate certificateOfSigner, @NotNull Function2<? super byte[], ? super Integer, ? extends List<DecodedData>> decode) {
        Intrinsics.checkParameterIsNotNull((Object)signedData, (String)"signedData");
        Intrinsics.checkParameterIsNotNull((Object)decodedSignedData, (String)"decodedSignedData");
        Intrinsics.checkParameterIsNotNull((Object)certificateOfSigner, (String)"certificateOfSigner");
        Intrinsics.checkParameterIsNotNull(decode, (String)"decode");
        SignedDataDecoder.DefaultImpls.recoverSignedData(this, signedData, decodedSignedData, certificateOfSigner, decode);
    }

    @Override
    @NotNull
    public SignedDataDecoder.RecoveryResult recoverText(@NotNull String signedData, @NotNull RecoveredPublicKeyCertificate certificateOfSigner, int startIndexInBytes, @NotNull Function2<? super byte[], ? super Integer, ? extends List<DecodedData>> decode) {
        Intrinsics.checkParameterIsNotNull((Object)signedData, (String)"signedData");
        Intrinsics.checkParameterIsNotNull((Object)certificateOfSigner, (String)"certificateOfSigner");
        Intrinsics.checkParameterIsNotNull(decode, (String)"decode");
        return SignedDataDecoder.DefaultImpls.recoverText(this, signedData, certificateOfSigner, startIndexInBytes, decode);
    }

    @Override
    @NotNull
    public SignedDataDecoder.RecoveryResult recoverCertificate(@NotNull BerTlv encryptedCertificate, @NotNull DecodedData decodedCertificate, @NotNull PublicKeyCertificate certificateOfSigner, @NotNull Function3<? super byte[], ? super Integer, ? super Integer, RecoveredPublicKeyCertificate> decode) {
        Intrinsics.checkParameterIsNotNull((Object)encryptedCertificate, (String)"encryptedCertificate");
        Intrinsics.checkParameterIsNotNull((Object)decodedCertificate, (String)"decodedCertificate");
        Intrinsics.checkParameterIsNotNull((Object)certificateOfSigner, (String)"certificateOfSigner");
        Intrinsics.checkParameterIsNotNull(decode, (String)"decode");
        return SignedDataDecoder.DefaultImpls.recoverCertificate((SignedDataDecoder)this, encryptedCertificate, decodedCertificate, certificateOfSigner, decode);
    }
}

