/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.Decoder;
import io.github.binaryfoo.TagInfo;
import io.github.binaryfoo.TagMetaData;
import io.github.binaryfoo.decoders.DecodeSession;
import io.github.binaryfoo.tlv.BerTlv;
import io.github.binaryfoo.tlv.CommonVendorErrorMode;
import io.github.binaryfoo.tlv.CompliantTagMode;
import io.github.binaryfoo.tlv.HexExtensionsKt;
import io.github.binaryfoo.tlv.ISOUtil;
import io.github.binaryfoo.tlv.Tag;
import io.github.binaryfoo.tlv.TagKt;
import io.github.binaryfoo.tlv.TagRecognitionMode;
import io.github.binaryfoo.tlv.TlvParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00050\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u0018\u001a\u00020\rH\u0016J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u001a"}, d2={"Lio/github/binaryfoo/decoders/TLVDecoder;", "Lio/github/binaryfoo/Decoder;", "()V", "decode", "Lkotlin/Pair;", "", "Lio/github/binaryfoo/tlv/BerTlv;", "Lio/github/binaryfoo/DecodedData;", "input", "", "session", "Lio/github/binaryfoo/decoders/DecodeSession;", "startIndexInBytes", "", "mode", "Lio/github/binaryfoo/tlv/TagRecognitionMode;", "decodeOrBackDown", "compositeStartElementIndex", "tagInfo", "Lio/github/binaryfoo/TagInfo;", "valueAsHexString", "decodeTlvs", "list", "startIndex", "getMaxLength", "validate", "emv-bertlv"})
public final class TLVDecoder
implements Decoder {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DecodedData> decode(@NotNull String input, int startIndexInBytes, @NotNull DecodeSession session) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        try {
            return (List)TLVDecoder.decode$default(this, input, session, startIndexInBytes, null, 8, null).getSecond();
        }
        catch (TlvParseException e) {
            String errorMessage;
            String string = e.getMessage();
            if (string == null) {
                string = errorMessage = e.getClass().getSimpleName();
            }
            if (Intrinsics.areEqual((Object)session.getTagRecognitionMode(), (Object)CommonVendorErrorMode.INSTANCE)) {
                Pair<List<BerTlv>, List<DecodedData>> $this$filterTo$iv$iv;
                Iterable $this$filter$iv = e.getResultsSoFar();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    BerTlv p1 = (BerTlv)element$iv$iv;
                    boolean bl = false;
                    if (!TagKt.hasCommonVendorErrorTag(p1)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                if (!((List)destination$iv$iv).isEmpty()) {
                    try {
                        void $this$mapTo$iv$iv;
                        BerTlv p1;
                        Iterable $this$filterTo$iv$iv2;
                        void tlvs;
                        $this$filterTo$iv$iv = this.decode(input, session, startIndexInBytes, CommonVendorErrorMode.INSTANCE);
                        $this$filter$iv = (List)$this$filterTo$iv$iv.component1();
                        List decoded = (List)$this$filterTo$iv$iv.component2();
                        Iterable $this$filter$iv2 = (Iterable)tlvs;
                        boolean $i$f$filter2 = false;
                        Iterable iterable2 = $this$filter$iv2;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo2 = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                            p1 = (BerTlv)element$iv$iv;
                            boolean bl = false;
                            if (!TagKt.hasCommonVendorErrorTag(p1)) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        Collection<String> collection = (List)destination$iv$iv2;
                        Iterable $this$map$iv = collection;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv2 = $this$map$iv;
                        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            p1 = (BerTlv)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl = false;
                            String string2 = it.getTag().getHexString();
                            collection.add(string2);
                        }
                        collection = (List)destination$iv$iv2;
                        Collection collection2 = collection;
                        List tagErrors = CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)new HashSet(collection2)));
                        DecodedData warning = new DecodedData(null, "Warning", "This result is a second attempt ignoring the spec for these (often abused) tags: " + tagErrors + ". The first attempt (following the the spec) produced an error: " + errorMessage, 0, 0, null, null, null, "parse-warning", 224, null);
                        return CollectionsKt.plus((Collection)decoded, (Object)warning);
                    }
                    catch (TlvParseException tlvs) {
                        // empty catch block
                    }
                }
            }
            List<DecodedData> decoded = this.decodeTlvs(e.getResultsSoFar(), startIndexInBytes, session);
            String string3 = errorMessage;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"errorMessage");
            DecodedData decodedData = (DecodedData)CollectionsKt.lastOrNull(decoded);
            DecodedData error = new DecodedData(null, "Error", string3, decodedData != null ? decodedData.getEndIndex() : 0, input.length() / 2, null, null, null, "parse-error", 224, null);
            return CollectionsKt.plus((Collection)decoded, (Object)error);
        }
    }

    private final Pair<List<BerTlv>, List<DecodedData>> decode(String input, DecodeSession session, int startIndexInBytes, TagRecognitionMode mode) {
        List<BerTlv> tlvs = BerTlv.Companion.parseList(HexExtensionsKt.decodeAsHex(input), true, mode);
        List<DecodedData> decoded = this.decodeTlvs(tlvs, startIndexInBytes, session);
        return new Pair(tlvs, decoded);
    }

    static /* synthetic */ Pair decode$default(TLVDecoder tLVDecoder, String string, DecodeSession decodeSession, int n, TagRecognitionMode tagRecognitionMode, int n2, Object object) {
        if ((n2 & 8) != 0) {
            tagRecognitionMode = CompliantTagMode.INSTANCE;
        }
        return tLVDecoder.decode(string, decodeSession, n, tagRecognitionMode);
    }

    private final List<DecodedData> decodeTlvs(List<? extends BerTlv> list, int startIndex, DecodeSession session) {
        int currentStartIndex = startIndex;
        ArrayList<DecodedData> decodedItems = new ArrayList<DecodedData>();
        for (BerTlv berTlv : list) {
            DecodedData decodedData;
            TagMetaData tagMetaData;
            String valueAsHexString = berTlv.getValueAsHexString();
            Tag tag = berTlv.getTag();
            int length = berTlv.toBinary().length;
            int contentEndIndex = currentStartIndex + length;
            int compositeStartElementIndex = currentStartIndex + berTlv.getStartIndexOfValue();
            if (session.getTagMetaData() == null) {
                Intrinsics.throwNpe();
            }
            if (tag.getConstructed()) {
                decodedData = DecodedData.Companion.fromTlv(berTlv, tagMetaData, valueAsHexString, currentStartIndex, contentEndIndex, this.decodeTlvs(berTlv.getChildren(), compositeStartElementIndex, session));
            } else {
                TagInfo tagInfo = tagMetaData.get(tag);
                decodedData = DecodedData.Companion.fromTlv(berTlv, tagMetaData, tagInfo.decodePrimitiveTlvValue(valueAsHexString), currentStartIndex, contentEndIndex, this.decodeOrBackDown(compositeStartElementIndex, tagInfo, valueAsHexString, session));
            }
            DecodedData decoded = decodedData;
            decodedItems.add(decoded);
            currentStartIndex += length;
        }
        return decodedItems;
    }

    private final List<DecodedData> decodeOrBackDown(int compositeStartElementIndex, TagInfo tagInfo, String valueAsHexString, DecodeSession session) {
        try {
            return tagInfo.getDecoder().decode(valueAsHexString, compositeStartElementIndex, session);
        }
        catch (Exception e) {
            String string = "Error: Failed parsing " + valueAsHexString;
            String string2 = e.getMessage();
            if (string2 == null) {
                String string3 = e.getClass().getSimpleName();
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"e.javaClass.simpleName");
            }
            return CollectionsKt.listOf((Object)new DecodedData(null, string, string2, compositeStartElementIndex, compositeStartElementIndex + valueAsHexString.length() / 2, null, null, null, "parse-error", 224, null));
        }
    }

    @Override
    public int getMaxLength() {
        return 10000;
    }

    @Override
    @Nullable
    public String validate(@Nullable String input) {
        if (input == null || input.length() < 2) {
            return "Value must be at least 2 characters";
        }
        if (input.length() % 2 != 0) {
            return "Length must be a multiple of 2";
        }
        if (!ISOUtil.isValidHexString(input)) {
            return "Value must contain only the characters 0-9 and A-F";
        }
        return null;
    }
}

