/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders.apdu;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.Decoder;
import io.github.binaryfoo.decoders.DecodeSession;
import io.github.binaryfoo.decoders.ICCPublicKeyDecoder;
import io.github.binaryfoo.decoders.IssuerPublicKeyDecoder;
import io.github.binaryfoo.decoders.SignedDynamicApplicationDataDecoder;
import io.github.binaryfoo.decoders.SignedStaticApplicationDataDecoder;
import io.github.binaryfoo.decoders.annotator.BackgroundReading;
import io.github.binaryfoo.decoders.annotator.SignedDataDecoder;
import io.github.binaryfoo.decoders.apdu.APDUCommand;
import io.github.binaryfoo.decoders.apdu.CommandAPDUDecoder;
import io.github.binaryfoo.decoders.apdu.ReplyAPDUDecoder;
import io.github.binaryfoo.hex.HexDumpElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/github/binaryfoo/decoders/apdu/APDUSequenceDecoder;", "Lio/github/binaryfoo/Decoder;", "replyDecoder", "Lio/github/binaryfoo/decoders/apdu/ReplyAPDUDecoder;", "commandDecoders", "", "Lio/github/binaryfoo/decoders/apdu/CommandAPDUDecoder;", "(Lio/github/binaryfoo/decoders/apdu/ReplyAPDUDecoder;[Lio/github/binaryfoo/decoders/apdu/CommandAPDUDecoder;)V", "_commandDecoders", "[Lio/github/binaryfoo/decoders/apdu/CommandAPDUDecoder;", "signedDataRecoverers", "", "Lio/github/binaryfoo/decoders/annotator/SignedDataDecoder;", "decode", "Lio/github/binaryfoo/DecodedData;", "input", "", "startIndexInBytes", "", "session", "Lio/github/binaryfoo/decoders/DecodeSession;", "getCommandDecoder", "getMaxLength", "postProcess", "", "decoded", "validate", "emv-bertlv"})
public final class APDUSequenceDecoder
implements Decoder {
    private final CommandAPDUDecoder[] _commandDecoders;
    private final List<SignedDataDecoder> signedDataRecoverers;
    private final ReplyAPDUDecoder replyDecoder;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DecodedData> decode(@NotNull String input, int startIndexInBytes, @NotNull DecodeSession session) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        int runningStartIndexInBytes = startIndexInBytes;
        ArrayList<DecodedData> list = new ArrayList<DecodedData>();
        CharSequence charSequence = input;
        boolean bl = false;
        String string = charSequence.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toUpperCase()");
        charSequence = string;
        Regex regex = new Regex("\\s+");
        int n = 0;
        boolean bl2 = false;
        Iterable $this$filter$iv = regex.split(charSequence, n);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            CharSequence charSequence2 = it;
            boolean bl4 = false;
            if (!(!StringsKt.isBlank((CharSequence)charSequence2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl5 = false;
            try {
                CommandAPDUDecoder commandDecoder = this.getCommandDecoder(line);
                DecodedData decoded = null;
                if (commandDecoder != null) {
                    session.setCurrentCommand(commandDecoder.getCommand());
                    decoded = commandDecoder.decode(line, runningStartIndexInBytes, session);
                    decoded.setCategory("c-apdu");
                    decoded.setBackgroundReading(BackgroundReading.Companion.readingFor(commandDecoder.getCommand()));
                } else {
                    decoded = this.replyDecoder.decode(line, runningStartIndexInBytes, session);
                    decoded.setCategory("r-apdu");
                }
                decoded.setHexDump(HexDumpElement.Companion.splitIntoByteLengthStrings(line, runningStartIndexInBytes));
                runningStartIndexInBytes = decoded.getEndIndex();
                list.add(decoded);
            }
            catch (Exception e) {
                list.add(DecodedData.Companion.primitive(line, "Failed to decode: " + e.getMessage(), 0, 0));
            }
        }
        this.postProcess((List<DecodedData>)list, session);
        return list;
    }

    private final CommandAPDUDecoder getCommandDecoder(String input) {
        CommandAPDUDecoder commandAPDUDecoder;
        block2: {
            String string = input;
            int n = 0;
            int n2 = 4;
            APDUCommand.Companion companion = APDUCommand.Companion;
            int n3 = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string4 = string3;
            APDUCommand command = companion.fromHex(string4);
            CommandAPDUDecoder[] $this$firstOrNull$iv = this._commandDecoders;
            boolean $i$f$firstOrNull = false;
            CommandAPDUDecoder[] commandAPDUDecoderArray = $this$firstOrNull$iv;
            n3 = commandAPDUDecoderArray.length;
            for (int i = 0; i < n3; ++i) {
                CommandAPDUDecoder element$iv;
                CommandAPDUDecoder it = element$iv = commandAPDUDecoderArray[i];
                boolean bl = false;
                if (!(it.getCommand() == command)) continue;
                commandAPDUDecoder = element$iv;
                break block2;
            }
            commandAPDUDecoder = null;
        }
        return commandAPDUDecoder;
    }

    @Override
    @Nullable
    public String validate(@Nullable String input) {
        return null;
    }

    @Override
    public int getMaxLength() {
        return Integer.MAX_VALUE;
    }

    public final void postProcess(@NotNull List<DecodedData> decoded, @NotNull DecodeSession session) {
        Intrinsics.checkParameterIsNotNull(decoded, (String)"decoded");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        for (SignedDataDecoder processor : this.signedDataRecoverers) {
            try {
                processor.decodeSignedData(session, decoded);
            }
            catch (Exception exception) {}
        }
    }

    public APDUSequenceDecoder(@NotNull ReplyAPDUDecoder replyDecoder, CommandAPDUDecoder ... commandDecoders) {
        Intrinsics.checkParameterIsNotNull((Object)replyDecoder, (String)"replyDecoder");
        Intrinsics.checkParameterIsNotNull((Object)commandDecoders, (String)"commandDecoders");
        this.replyDecoder = replyDecoder;
        this._commandDecoders = Arrays.copyOf(commandDecoders, commandDecoders.length);
        this.signedDataRecoverers = CollectionsKt.listOf((Object[])new SignedDataDecoder[]{new IssuerPublicKeyDecoder(), new ICCPublicKeyDecoder(), new SignedStaticApplicationDataDecoder(), new SignedDynamicApplicationDataDecoder()});
    }
}

