/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders.apdu;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.EmvTags;
import io.github.binaryfoo.decoders.DecodeSession;
import io.github.binaryfoo.decoders.TLVDecoder;
import io.github.binaryfoo.decoders.apdu.ResponseCode;
import io.github.binaryfoo.tlv.Tag;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0002J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/github/binaryfoo/decoders/apdu/ReplyAPDUDecoder;", "", "tlvDecoder", "Lio/github/binaryfoo/decoders/TLVDecoder;", "(Lio/github/binaryfoo/decoders/TLVDecoder;)V", "addToSession", "", "session", "Lio/github/binaryfoo/decoders/DecodeSession;", "children", "", "Lio/github/binaryfoo/DecodedData;", "tags", "Lio/github/binaryfoo/tlv/Tag;", "decode", "input", "", "startIndexInBytes", "", "emv-bertlv"})
public final class ReplyAPDUDecoder {
    private final TLVDecoder tlvDecoder;

    @NotNull
    public final DecodedData decode(@NotNull String input, int startIndexInBytes, @NotNull DecodeSession session) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        int statusBytesStart = input.length() - 4;
        int endIndex = 0;
        List<DecodedData> children = null;
        String decodedData = null;
        if (input.length() == 4) {
            String string = input;
            ResponseCode.Companion companion = ResponseCode.Companion;
            boolean bl = false;
            String string2 = string.substring(statusBytesStart);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            String string3 = string2;
            ResponseCode responseCode = companion.lookup(string3);
            decodedData = responseCode.getHex() + " " + responseCode.getDescription();
            boolean bl2 = false;
            children = CollectionsKt.emptyList();
            endIndex = startIndexInBytes + 2;
        } else {
            String responseCode = input;
            int n = 0;
            String string = responseCode.substring(statusBytesStart);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            decodedData = string;
            responseCode = input;
            n = 0;
            TLVDecoder tLVDecoder = this.tlvDecoder;
            boolean bl = false;
            String string4 = responseCode.substring(n, statusBytesStart);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = string4;
            children = tLVDecoder.decode(string5, startIndexInBytes, session);
            List<Tag> list = Arrays.asList(EmvTags.PDOL, EmvTags.CDOL_1, EmvTags.CDOL_2, EmvTags.DDOL);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(EmvTags.PD\u2026ags.CDOL_2, EmvTags.DDOL)");
            this.addToSession(session, children, list);
            DecodedData payload = children.get(0);
            endIndex = payload.getEndIndex() + 2;
        }
        return DecodedData.Companion.constructed("R-APDU", decodedData, startIndexInBytes, endIndex, children);
    }

    private final void addToSession(DecodeSession session, List<DecodedData> children, List<Tag> tags) {
        for (DecodedData child : children) {
            if (child.getTag() != null && tags.contains(child.getTag())) {
                session.put(child.getTag(), child.getFullDecodedData());
                continue;
            }
            if (!child.isComposite()) continue;
            this.addToSession(session, child.getChildren(), tags);
        }
    }

    public ReplyAPDUDecoder(@NotNull TLVDecoder tlvDecoder) {
        Intrinsics.checkParameterIsNotNull((Object)tlvDecoder, (String)"tlvDecoder");
        this.tlvDecoder = tlvDecoder;
    }
}

